/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it25;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;
import se.ericsson.lte.rbs.omf.aue.step1.OtherFragmentUtilityWrapper;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRef;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRefParser;

public class SetConfiguredMaxTxPowerAttributeAction
extends AbstractStep1ConversionAction {
    private static final String MO_FRAGMENT_CAT = "cat";
    private static final String PART_OF_SECTOR_POWER = "partOfSectorPower";
    private static final String SECTOR_FUNCTION_REF = "sectorFunctionRef";
    private static final String CONFIGURED_MAX_TX_POWER = "configuredMaxTxPower";
    private static final String CONFIGURED_OUTPUT_POWER = "configuredOutputPower";
    private static final Class THIS_CLASS = SetConfiguredMaxTxPowerAttributeAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getValueFromModificationFile("Mo");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, string);
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeColumn(tableData, string, SECTOR_FUNCTION_REF);
            Object[] objectArray2 = this.getAttributeColumn(tableData, string, PART_OF_SECTOR_POWER);
            int n = tableData.getNumberOfRecords();
            for (int i = 0; i < n; ++i) {
                MoRef moRef = MoRefParser.parseMoRef(objectArray[i].toString());
                Object object = OtherFragmentUtilityWrapper.getOtherFragmentUtilityInstance().getAttribute(MO_FRAGMENT_CAT, moRef.ldn, CONFIGURED_OUTPUT_POWER);
                int n2 = (Integer)object * (Integer)objectArray2[i] / 100;
                this.setAttributeValue(tableData, string, i, CONFIGURED_MAX_TX_POWER, new Integer(n2));
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }
}

