/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it25;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;
import se.ericsson.lte.rbs.omf.aue.step1.util.ComplexArrayUtil;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRef;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRefParser;

public class SetServiceAreaIdOnMbsfnAreaAction
extends AbstractStep1ConversionAction {
    private static final String MOTYPE_MBSFNAREA = "MbsfnArea";
    private static final String MOTYPE_MBSFNAREACELLRELATION = "MbsfnAreaCellRelation";
    private static final String MOTYPE_EUTRANCELL_FDD = "EUtranCellFDD";
    private static final String ATTRIBUTE_SERVICE_AREA_ID = "serviceAreaId";
    private static final String ATTRIBUTE_LDN = "ldn";
    private static final String ATTRIBUTE_MBSFNAREACELL_REF = "mbsfnAreaCellRef";
    private static final Class THIS_CLASS = SetServiceAreaIdOnMbsfnAreaAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        Map map;
        logger.traceEnter(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::convert");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, MOTYPE_EUTRANCELL_FDD);
        if (tableData.isNotEmpty() && !(map = this.getCellToServiceAreaIdMap(tableData, MOTYPE_EUTRANCELL_FDD)).isEmpty()) {
            Map map2 = this.getMbsfnAreaToSaiMap(tableHandler, map);
            this.updateMbsfnAreaSai(tableHandler, map2);
        }
        logger.traceReturn(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::convert");
    }

    private Map getCellToServiceAreaIdMap(TableData tableData, String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::getCellToServiceAreaIdMap");
        Object[] objectArray = this.getAttributeColumn(tableData, string, ATTRIBUTE_LDN);
        Object[] objectArray2 = this.getAttributeColumn(tableData, string, ATTRIBUTE_SERVICE_AREA_ID);
        int n = tableData.getNumberOfRecords();
        HashMap<Object, List> hashMap = new HashMap<Object, List>();
        for (int i = 0; i < n; ++i) {
            List list = ComplexArrayUtil.paraseU32Array((String)objectArray2[i]);
            if (list.isEmpty()) continue;
            hashMap.put(objectArray[i], list);
        }
        logger.traceReturn(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::getCellToServiceAreaIdMap");
        return hashMap;
    }

    private Map getMbsfnAreaToSaiMap(TableHandler tableHandler, Map map) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::getMbsfnAreaToSaiMap");
        HashMap hashMap = new HashMap();
        TableData tableData = this.getTableData(tableHandler, MOTYPE_MBSFNAREACELLRELATION);
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeColumn(tableData, MOTYPE_MBSFNAREACELLRELATION, ATTRIBUTE_LDN);
            Object[] objectArray2 = this.getAttributeColumn(tableData, MOTYPE_MBSFNAREACELLRELATION, ATTRIBUTE_MBSFNAREACELL_REF);
            int n = tableData.getNumberOfRecords();
            for (int i = 0; i < n; ++i) {
                TreeSet treeSet;
                String string = LdnUtil.getParentLdn((String)objectArray[i].toString());
                MoRef moRef = MoRefParser.parseMoRef((String)objectArray2[i]);
                if (!map.containsKey(moRef.getLdn())) continue;
                if (hashMap.containsKey(string)) {
                    treeSet = (TreeSet)hashMap.get(string);
                    treeSet.addAll((List)map.get(moRef.getLdn()));
                    while (treeSet.size() > 64) {
                        treeSet.remove(treeSet.last());
                    }
                    continue;
                }
                treeSet = new TreeSet((List)map.get(moRef.getLdn()));
                hashMap.put(string, treeSet);
            }
        }
        logger.traceReturn(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::getMbsfnAreaToSaiMap");
        return hashMap;
    }

    private void updateMbsfnAreaSai(TableHandler tableHandler, Map map) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::updateMbsfnAreaSai");
        if (!map.isEmpty()) {
            TableData tableData = this.getTableData(tableHandler, MOTYPE_MBSFNAREA);
            Object[] objectArray = this.getAttributeColumn(tableData, MOTYPE_MBSFNAREA, ATTRIBUTE_LDN);
            int n = tableData.getNumberOfRecords();
            for (int i = 0; i < n; ++i) {
                if (!map.containsKey(objectArray[i])) continue;
                this.setAttributeValue(tableData, MOTYPE_MBSFNAREA, i, ATTRIBUTE_SERVICE_AREA_ID, this.buildSaiString((SortedSet)map.get(objectArray[i])));
            }
        }
        logger.traceReturn(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::updateMbsfnAreaSai");
    }

    private String buildSaiString(SortedSet sortedSet) {
        logger.traceEnter(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::buildSaiString");
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("<complex><seq name=\"serviceAreaId\" type=\"S32\"/><data>");
        stringBuffer.append(sortedSet.size());
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(',');
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append("</data></complex>");
        logger.traceReturn(THIS_CLASS, "SetServiceAreaIdOnMbsfnAreaAction::buildSaiString");
        return stringBuffer.toString();
    }
}

