/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.util;

import java.io.CharArrayReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRef;

public class MoRefParser
extends DefaultHandler {
    private static final Class THIS_CLASS = MoRefParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private MoRef moRef = null;

    public static MoRef parseMoRef(String string) throws CrbsAueException {
        MoRef moRef = null;
        if (MoRefParser.isComplexXml(string)) {
            moRef = MoRefParser.parseComplexXml(string);
        } else {
            try {
                logger.traceEnter(THIS_CLASS, "parseMoRef() " + string);
                CharArrayReader charArrayReader = new CharArrayReader(string.trim().toCharArray());
                InputSource inputSource = new InputSource(charArrayReader);
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                MoRefParser moRefParser = new MoRefParser();
                xMLReader.setContentHandler(moRefParser);
                xMLReader.setErrorHandler(moRefParser);
                xMLReader.parse(inputSource);
                moRef = moRefParser.getMoRef();
            }
            catch (Exception exception) {
                throw new CrbsAueException("Failed to parse moref " + string, (Throwable)exception);
            }
        }
        return moRef;
    }

    private static MoRef parseComplexXml(String string) {
        int n = string.indexOf("<data>");
        int n2 = string.indexOf("</data>");
        String string2 = string.substring(n + 6, n2);
        int n3 = string2.lastIndexOf(44);
        String string3 = string2.substring(n3 + 1);
        string2 = string2.substring(0, n3);
        n3 = string2.lastIndexOf(44);
        String string4 = string2.substring(n3 + 1);
        string2 = string2.substring(0, n3);
        String string5 = MoRefParser.replaceAll(string2, "\\", "");
        MoRef moRef = new MoRef();
        moRef.setFroId(Integer.parseInt(string3));
        moRef.setFroTypeId(Integer.parseInt(string4));
        moRef.setLdn(string5);
        return moRef;
    }

    public static String replaceAll(String string, String string2, String string3) {
        String string4 = string;
        int n = string.indexOf(string2);
        if (n != -1) {
            int n2 = string2.length();
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n != -1) {
                stringBuffer.append(cArray, n3, n - n3);
                stringBuffer.append(string3);
                n3 = n + n2;
                n = string.indexOf(string2, n3);
            }
            stringBuffer.append(cArray, n3, cArray.length - n3);
            string4 = stringBuffer.toString();
        }
        return string4;
    }

    private static boolean isComplexXml(String string) {
        int n = string.indexOf("<complex>");
        return n != -1;
    }

    protected MoRef getMoRef() {
        return this.moRef;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        logger.traceEnter(this.getClass(), "startElement " + string3);
        if ("moref".equalsIgnoreCase(string3)) {
            this.startMoRef(attributes);
        } else if ("attr".equalsIgnoreCase(string3)) {
            this.startAttr(attributes);
        }
        logger.traceReturn(this.getClass(), "startElement");
    }

    private void startAttr(Attributes attributes) {
        String string = null;
        String string2 = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).equalsIgnoreCase("name")) {
                string = attributes.getValue(i);
                continue;
            }
            if (!attributes.getQName(i).equalsIgnoreCase("value")) continue;
            string2 = attributes.getValue(i);
        }
        if ("ldn".equalsIgnoreCase(string)) {
            this.moRef.ldn = string2;
        } else if ("frotype".equalsIgnoreCase(string)) {
            this.moRef.froTypeId = Integer.parseInt(string2);
        } else if ("froid".equalsIgnoreCase(string)) {
            this.moRef.froId = Integer.parseInt(string2);
        }
    }

    private void startMoRef(Attributes attributes) {
        String string = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).equalsIgnoreCase("name")) continue;
            string = attributes.getValue(i);
        }
        this.moRef = new MoRef(string);
    }
}

