/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe;

import javax.swing.JComponent;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.swe.LdnMvcContainer;
import se.ericsson.cello.swe.controller.UpSweController;
import se.ericsson.cello.swe.controller.UpSweControllerFactory;
import se.ericsson.cello.swe.model.UpSweModel;
import se.ericsson.cello.swe.model.UpSweModelFactory;
import se.ericsson.cello.swe.service.Configuration;
import se.ericsson.cello.swe.service.SweToolServiceFactory;
import se.ericsson.cello.swe.service.SweToolServices;
import se.ericsson.cello.swe.view.UpSweView;
import se.ericsson.cello.swe.view.UpSweViewFactory;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class UpLdnMvcContainerImpl
implements LdnMvcContainer {
    private String myLdn;
    private NodeServices myNodeServices;
    private SweToolServices myToolServices;
    private Configuration myConfiguration;
    private UpSweModel myUpSweModel = null;
    private UpSweController myUpSweController = null;
    private UpSweView myUpSweView = null;
    private Launchable myParentLaunchble = null;
    private LauncherInterface myLauncher = null;

    public UpLdnMvcContainerImpl(String myLdn, NodeServices aNodeServices, Configuration aConfiguration, Launchable parentLaunchble, LauncherInterface theLauncher) {
        this.myLdn = myLdn;
        this.myNodeServices = aNodeServices;
        this.myConfiguration = aConfiguration;
        this.myParentLaunchble = parentLaunchble;
        this.myLauncher = theLauncher;
        this.initModelViewControllerStructure();
    }

    public void activate() {
    }

    public void doStart() {
        this.myUpSweController.showUIView(true);
    }

    public void doStop() {
        this.myUpSweView.exit();
    }

    public String getLdn() {
        return this.myLdn;
    }

    private void initModelViewControllerStructure() {
        this.myToolServices = SweToolServiceFactory.createToolServices(this.myParentLaunchble, this.myLauncher, this.myConfiguration, this.myNodeServices);
        this.myUpSweModel = UpSweModelFactory.createUpSweModel(this.myLdn, this.myToolServices, this.myConfiguration);
        this.myUpSweController = UpSweControllerFactory.createUpSweController(this.myUpSweModel);
        this.myUpSweView = UpSweViewFactory.createUpSweView(this.myUpSweController, this.myUpSweModel);
        this.myUpSweView.initialize();
        this.myUpSweController.setView(this.myUpSweView);
        this.myUpSweModel.addUiView(this.myUpSweView);
    }

    public JComponent getComponent() {
        return this.myUpSweView.getComponent();
    }

    public void refresh(String itemToSelect) {
        this.myUpSweModel.refreshUiView();
        this.myUpSweView.selectRowWithItem(itemToSelect);
    }
}

