/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.event.ActionEvent;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.service.SweToolServices;

public class CvHyperToolAction
extends AbstractAction {
    private static final String NAME = "name";
    private static final long serialVersionUID = 6309841603665826721L;
    private String theLdn = null;
    private SweToolServices myToolServices = null;
    private JTable myCvTable = null;

    public CvHyperToolAction(String theLdn, JTable aCvTable, SweToolServices myToolServices) {
        this.theLdn = theLdn;
        this.myToolServices = myToolServices;
        this.myCvTable = aCvTable;
    }

    public void actionPerformed(ActionEvent e) {
        String iconPath;
        String toolName = this.getToolName(e);
        if (toolName == null) {
            return;
        }
        Properties props = this.myToolServices.getConfiguration().getSupersedingProperties();
        String configFileName = null;
        String cvName = this.getSelectedCvName();
        if (cvName != null) {
            props.setProperty("CVNAME", cvName);
        }
        if (this.theLdn != null) {
            props.setProperty("LDNs", this.theLdn);
            if (toolName.equals("Create CV...")) {
                props.setProperty("MOACTION", "create");
                configFileName = this.myToolServices.getConfiguration().getConfigurationFile("Create CV...");
            } else if (toolName.equals("Put to FTP...")) {
                props.setProperty("MOACTION", "putToFtpServer");
                props.setProperty("PROGRESS_DISPLAY_OF_ACTION_EXECUTION", "yes");
                props.setProperty("PROGRESS_DISPLAY_ATTRIBUTE", "currentDetailedActivity");
                props.setProperty("PROGRESS_STOP_ATTRIBUTES", "currentMainActivity==0");
                props.setProperty("PROGRESS_SUPERVISION_ATTRIBUTES", "currentMainActivity;actionResult;additionalActionResultData");
                if (cvName != null) {
                    props.setProperty("MOACTION_PARAMETER_VALUES", "cvName=" + cvName);
                }
                configFileName = this.myToolServices.getConfiguration().getConfigurationFile("Put to FTP...");
            }
        }
        if (null != (iconPath = this.myToolServices.getConfiguration().getIconToPassOn())) {
            props.setProperty("TOOL_ICON", iconPath);
        }
        if (configFileName == null) {
            configFileName = this.myToolServices.getConfiguration().getConfigurationFile(toolName);
        }
        SweLog.logger().log(Level.INFO, "CvHyperToolAction: configFileName: " + configFileName);
        SweLog.logger().log(Level.INFO, "CvHyperToolAction: Properties sent: props: " + props);
        try {
            this.myToolServices.startHyperTool(configFileName, props);
        }
        catch (Exception ex) {
            MessageDialogFactory.createMessageDialog((String)("It was not possible to start " + toolName), (Exception)ex, (boolean)false, null).setVisible(true);
        }
    }

    private String getToolName(ActionEvent e) {
        String toolName = null;
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton item = (AbstractButton)e.getSource();
            toolName = item.getText();
        }
        return toolName;
    }

    private String getSelectedCvName() {
        String cvName = null;
        int rowNum = this.myCvTable.getSelectedRow();
        int colNum = this.getNameColumn();
        if (rowNum != -1 && colNum != -1) {
            cvName = (String)this.myCvTable.getValueAt(rowNum, colNum);
        }
        return cvName;
    }

    private int getNameColumn() {
        TableColumnModel colModel = this.myCvTable.getTableHeader().getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            String colName = this.myCvTable.getColumnName(i);
            if (!colName.equals(NAME)) continue;
            return i;
        }
        return -1;
    }
}

