/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.model.CvSweModel;
import se.ericsson.cello.swe.service.Configuration;
import se.ericsson.cello.swe.service.SweToolServices;
import se.ericsson.cello.swe.view.gui.ColumnHeaderListener;
import se.ericsson.cello.swe.view.gui.CvHyperToolAction;
import se.ericsson.cello.swe.view.gui.LeftDotRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvTablePanel
extends JPanel {
    private static final long serialVersionUID = 1587075730651091262L;
    protected List<List<String>> myTableDataList = null;
    private int rbPosColumn = 0;
    protected DefaultTableModel theTableModel;
    private JTable table = null;
    private TablePopupMenu popupMenu = null;
    private ColumnHeaderListener myColumnHeaderListener;
    protected final String setStartable = "Set Startable";
    protected final String removeFromRbList = "Remove from Rollback List";
    protected final String addToRbList = "Add to Rollback List";
    protected final String reload = "Reload with this CV";
    protected final String remove = "Delete";
    protected String restore = "NoValue";
    private CvSweModel myModel = null;
    private String[] theTableHeader = null;
    private UserPreferencesI userPrefs;
    private ActionListener setStartableActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int rowN = CvTablePanel.this.getTable().getSelectedRow();
            if (rowN == -1) {
                return;
            }
            String aCvName = (String)CvTablePanel.this.getTable().getValueAt(rowN, 0);
            try {
                CvTablePanel.this.myModel.getMoModel().setStartable(aCvName);
                CvTablePanel.this.myModel.refreshUiView();
            }
            catch (Exception e1) {
                MessageDialogFactory.createMessageDialog((String)"The action Set Startable failed", (String)("It was not possible to set the CV " + aCvName + " to Startable"), (Exception)e1, (boolean)false, null).setVisible(true);
            }
        }
    };
    private ActionListener addToRbListActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int rowN = CvTablePanel.this.getTable().getSelectedRow();
            if (rowN == -1) {
                return;
            }
            String aCvName = (String)CvTablePanel.this.getTable().getValueAt(rowN, 0);
            CvTablePanel.this.myModel.getMoModel().setFirstRollbackList(aCvName);
            CvTablePanel.this.myModel.refreshUiView();
        }
    };
    private ActionListener removeFromRbListActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int rowN = CvTablePanel.this.getTable().getSelectedRow();
            if (rowN == -1) {
                return;
            }
            String aCvName = (String)CvTablePanel.this.getTable().getValueAt(rowN, 0);
            CvTablePanel.this.myModel.getMoModel().removeFromRollbackList(aCvName);
            CvTablePanel.this.myModel.refreshUiView();
        }
    };
    private ActionListener reloadActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int rowN = CvTablePanel.this.getTable().getSelectedRow();
            if (rowN == -1) {
                return;
            }
            String aCvName = (String)CvTablePanel.this.getTable().getValueAt(rowN, 0);
            try {
                CvTablePanel.this.myModel.getMoModel().setStartable(aCvName);
                SweLog.logger().log(Level.INFO, "setStartable done for: " + aCvName);
                CvTablePanel.this.myModel.refreshUiView();
                String actionName = "manualRestart";
                String rooLdn = "ManagedElement=1";
                SweToolServices myToolServices = CvTablePanel.this.myModel.getToolServices();
                Configuration myConfig = myToolServices.getConfiguration();
                String moPropToolName = myConfig.getToolName("MOPROPERTIES");
                Properties props = myConfig.getSupersedingProperties();
                props.setProperty("LDNs", rooLdn);
                props.setProperty("MOACTION", actionName);
                String iconPath = myConfig.getIconToPassOn();
                if (null != iconPath) {
                    props.setProperty("TOOL_ICON", iconPath);
                }
                String configFileName = myToolServices.getConfiguration().getConfigurationFile(moPropToolName);
                SweLog.logger().log(Level.INFO, "reload: configFileName: " + configFileName);
                try {
                    myToolServices.startHyperTool(configFileName, props);
                }
                catch (Exception ex) {
                    MessageDialogFactory.createMessageDialog((String)("It was not possible to start " + moPropToolName), (Exception)ex, (boolean)false, null).setVisible(true);
                }
            }
            catch (Exception e1) {
                MessageDialogFactory.createMessageDialog((String)"The action Reload with this CV failed", (String)("It was not possible to set the CV " + aCvName + " to Startable"), (Exception)e1, (boolean)false, null).setVisible(true);
            }
        }
    };
    private ActionListener removeActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int rowN = CvTablePanel.this.getTable().getSelectedRow();
            if (rowN == -1) {
                return;
            }
            String aCvName = (String)CvTablePanel.this.table.getValueAt(rowN, 0);
            String question = "The following CV will be deleted on the node " + CvTablePanel.this.myModel.getConfiguration().getHost() + ":\n" + aCvName + "\nDo you want to proceed?";
            Object[] options = new Object[]{"Delete", "Cancel"};
            int n = JOptionPane.showOptionDialog(CvTablePanel.this, question, CvTablePanel.this.myModel.getConfiguration().getManagerTitle() + " - Delete CV", 0, 3, null, options, options[0]);
            if (n != 0) {
                return;
            }
            CvTablePanel.this.myModel.getMoModel().deleteCV(aCvName);
            SweLog.logger().log(Level.INFO, "removeMenuItem done for: " + aCvName);
            CvTablePanel.this.myModel.refreshUiView();
        }
    };
    private MouseMotionListener toolTipListener = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent ev) {
            Point p = ev.getPoint().getLocation();
            int row = CvTablePanel.this.getTable().rowAtPoint(p);
            int column = CvTablePanel.this.getTable().columnAtPoint(p);
            if (row > -1 && column > -1) {
                CvTablePanel.this.getTable().setToolTipText(CvTablePanel.this.getTable().getValueAt(row, column).toString());
            }
        }
    };

    public CvTablePanel(List<List<String>> aTableDataListList, String[] theTableHeader, CvSweModel aModel, UserPreferencesI preferenceService) {
        super(new BorderLayout(0, 0));
        this.myModel = aModel;
        this.myTableDataList = aTableDataListList;
        this.theTableHeader = theTableHeader;
        this.userPrefs = preferenceService;
    }

    public void init() {
        this.rbPosColumn = this.myModel.getMoModel().getRbHeaderPosition();
        int nRows = this.myTableDataList.size();
        if (nRows == 0) {
            this.theTableModel = new DefaultTableModel();
        } else {
            int nCols = this.theTableHeader.length;
            Object[][] data = new Object[nRows][nCols];
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j < nCols; ++j) {
                    data[i][j] = this.myTableDataList.get(i).get(j);
                }
            }
            this.theTableModel = new DefaultTableModel(data, this.theTableHeader);
        }
        this.table = new JTable(this.theTableModel){
            private static final long serialVersionUID = -268329399240136878L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setName("tableCv");
        JTableHeader header = this.table.getTableHeader();
        this.myColumnHeaderListener = new ColumnHeaderListener(this.userPrefs, this.table);
        header.addMouseListener(this.myColumnHeaderListener);
        this.popupMenu = this.buildPopup();
        this.table.addMouseListener(new PopupListener(this.popupMenu));
        this.table.setAutoResizeMode(2);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoCreateColumnsFromModel(false);
        if (this.table.getColumnCount() > 0) {
            LeftDotRenderer leftDotRenderer = new LeftDotRenderer();
            this.table.getColumnModel().getColumn(0).setCellRenderer(leftDotRenderer);
        }
        int gapWidth = 10;
        int gapHeight = 4;
        this.table.setIntercellSpacing(new Dimension(gapWidth, gapHeight));
        this.table.setRowHeight(this.table.getRowHeight() + gapHeight);
        this.table.addMouseMotionListener(this.toolTipListener);
        this.table.setSelectionMode(0);
        this.myColumnHeaderListener.sortAllRowsBy(this.theTableModel);
        JScrollPane attrscroller = new JScrollPane(this.table, 20, 30);
        attrscroller.getHorizontalScrollBar().setUnitIncrement(50);
        attrscroller.getVerticalScrollBar().setUnitIncrement(30);
        this.add((Component)attrscroller, "Center");
    }

    public void setColumnSizes() {
        if (null != this.userPrefs) {
            int length = this.table.getColumnCount();
            for (int i = 0; i < length; ++i) {
                try {
                    Integer width = new Integer(this.userPrefs.getPreference("cpp_swembed_columnwidth_" + this.table.getName() + this.table.getColumnName(i) + "_", "0"));
                    if (width <= 0) continue;
                    this.table.getColumn(this.table.getColumnName(i)).setPreferredWidth(width);
                    continue;
                }
                catch (Exception e) {
                    SweLog.logger().info("Exception while setting preferred size to columns:\n" + SweLog.stackToString(e));
                }
            }
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public TablePopupMenu getPopup() {
        return this.popupMenu;
    }

    private TablePopupMenu buildPopup() {
        TablePopupMenu popup = new TablePopupMenu();
        popup.setName("cvTablePopup");
        JMenuItem setStartableItem = new JMenuItem("Set Startable");
        popup.add(setStartableItem);
        setStartableItem.addActionListener(this.setStartableActionListener);
        JMenuItem addToFirstMenuItem = new JMenuItem("Add to Rollback List");
        popup.add(addToFirstMenuItem);
        addToFirstMenuItem.addActionListener(this.addToRbListActionListener);
        JMenuItem removeFromRbListMenuItem = new JMenuItem("Remove from Rollback List");
        popup.add(removeFromRbListMenuItem);
        removeFromRbListMenuItem.addActionListener(this.removeFromRbListActionListener);
        JMenuItem reloadMenuItem = new JMenuItem("Reload with this CV");
        reloadMenuItem.setToolTipText("Set startable and open manualRestart window");
        popup.add(reloadMenuItem);
        reloadMenuItem.addActionListener(this.reloadActionListener);
        JMenuItem removeMenuItem = new JMenuItem("Delete");
        popup.add(removeMenuItem);
        removeMenuItem.addActionListener(this.removeActionListener);
        String theLdn = this.myModel.getLDN();
        SweToolServices myToolServices = this.myModel.getToolServices();
        this.restore = "Restore CV...";
        CvHyperToolAction menuItemAction = new CvHyperToolAction(theLdn, this.table, myToolServices);
        JMenuItem putToFtpMenuItem = new JMenuItem("Put to FTP...");
        popup.add(putToFtpMenuItem);
        putToFtpMenuItem.addActionListener(menuItemAction);
        JMenuItem restoreMenuItem = new JMenuItem(this.restore);
        popup.add(restoreMenuItem);
        restoreMenuItem.addActionListener(menuItemAction);
        return popup;
    }

    public DefaultTableModel getTheTableModel() {
        return this.theTableModel;
    }

    public TablePopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    private class PopupListener
    extends MouseAdapter {
        private TablePopupMenu popupMenu = null;

        public PopupListener(TablePopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Point clickPoint = new Point(e.getX(), e.getY());
                int selectedRow = CvTablePanel.this.table.rowAtPoint(clickPoint);
                if (selectedRow < 0 || selectedRow >= CvTablePanel.this.table.getRowCount()) {
                    return;
                }
                CvTablePanel.this.table.setRowSelectionInterval(selectedRow, selectedRow);
                this.popupMenu.beforeVisisble();
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public class TablePopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 7272977527996501490L;
        private LinkedList<JMenuItem> mItems = new LinkedList();

        public void addMenuItem(JMenuItem item) {
            this.mItems.add(item);
        }

        public JMenuItem add(JMenuItem item) {
            JMenuItem i = super.add(item);
            this.addMenuItem(item);
            return i;
        }

        public void beforeVisisble() {
            Iterator iter = this.mItems.iterator();
            JMenuItem aMenuItem = null;
            String actionName = null;
            while (iter.hasNext()) {
                aMenuItem = (JMenuItem)iter.next();
                actionName = aMenuItem.getActionCommand();
                boolean tobeEnabled = false;
                if (actionName.equals("Remove from Rollback List")) {
                    tobeEnabled = this.enableRemovefromRbList();
                    aMenuItem.setEnabled(tobeEnabled);
                    continue;
                }
                if (actionName.equals("Add to Rollback List")) {
                    tobeEnabled = this.enableAddToRbList();
                    aMenuItem.setEnabled(tobeEnabled);
                    continue;
                }
                if (actionName.equals("Delete")) {
                    tobeEnabled = this.enableDeleteCv();
                    aMenuItem.setEnabled(tobeEnabled);
                    continue;
                }
                if (!actionName.equals(CvTablePanel.this.restore)) continue;
                tobeEnabled = this.enableCvRestore();
                aMenuItem.setEnabled(tobeEnabled);
            }
        }

        protected boolean enableRemovefromRbList() {
            boolean enabled = false;
            String rbPos = null;
            int[] sRows = CvTablePanel.this.table.getSelectedRows();
            if (sRows == null || sRows.length == 0) {
                return false;
            }
            rbPos = (String)CvTablePanel.this.table.getValueAt(sRows[0], CvTablePanel.this.rbPosColumn);
            enabled = !rbPos.equals("");
            return enabled;
        }

        protected boolean enableAddToRbList() {
            boolean enabled = false;
            String rbPos = null;
            int[] sRows = CvTablePanel.this.table.getSelectedRows();
            if (sRows == null || sRows.length == 0) {
                return false;
            }
            rbPos = (String)CvTablePanel.this.table.getValueAt(sRows[0], CvTablePanel.this.rbPosColumn);
            enabled = rbPos.equals("");
            return enabled;
        }

        protected boolean enableDeleteCv() {
            boolean enabled = false;
            int[] sRows = CvTablePanel.this.table.getSelectedRows();
            if (sRows == null || sRows.length == 0) {
                return false;
            }
            String selectedCvName = (String)CvTablePanel.this.table.getValueAt(sRows[0], 0);
            enabled = CvTablePanel.this.myModel.getMoModel().canDelete(selectedCvName);
            return enabled;
        }

        protected boolean enableCvRestore() {
            boolean enabled = false;
            int[] sRows = CvTablePanel.this.table.getSelectedRows();
            if (sRows == null || sRows.length == 0) {
                return false;
            }
            String selectedCvName = (String)CvTablePanel.this.table.getValueAt(sRows[0], 0);
            enabled = CvTablePanel.this.myModel.getMoModel().isRestorable(selectedCvName);
            return enabled;
        }
    }
}

