/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.event.ActionEvent;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.service.SweToolServices;

public class UpHyperToolAction
extends AbstractAction {
    private static final String UPGRADE_PACKAGE_ID = "upgradePackageId";
    private static final long serialVersionUID = -2962196404759815846L;
    private SweToolServices myToolServices = null;
    private JTable myUpTable = null;

    public UpHyperToolAction(JTable aUpTable, SweToolServices myToolServices) {
        this.myToolServices = myToolServices;
        this.myUpTable = aUpTable;
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton item;
        String toolName = null;
        if (e.getSource() instanceof JMenuItem) {
            item = (JMenuItem)e.getSource();
            toolName = item.getText();
        } else if (e.getSource() instanceof JButton) {
            item = (JButton)e.getSource();
            toolName = item.getText();
        } else {
            return;
        }
        Properties props = this.myToolServices.getConfiguration().getSupersedingProperties();
        String upCreateToolName = this.myToolServices.getConfiguration().getToolName("UPCREATE");
        if (toolName.equals(upCreateToolName)) {
            SweLog.logger().log(Level.INFO, "UpHyperToolAction: Create UP with no LDNs parameter");
        } else {
            int rowN = this.myUpTable.getSelectedRow();
            int colN = this.getUpgradePackageIdColumn();
            if (rowN != -1 && colN != -1) {
                String sw = "ManagedElement=1,SwManagement=1,UpgradePackage=";
                String aUpLdn = (String)this.myUpTable.getValueAt(rowN, colN);
                aUpLdn = sw + aUpLdn;
                if (aUpLdn != null) {
                    props.setProperty("LDNs", aUpLdn);
                }
                SweLog.logger().log(Level.INFO, " aUpLdn: " + aUpLdn);
            }
        }
        String iconPath = this.myToolServices.getConfiguration().getIconToPassOn();
        if (null != iconPath) {
            props.setProperty("TOOL_ICON", iconPath);
        }
        String configFileName = this.myToolServices.getConfiguration().getConfigurationFile(toolName);
        SweLog.logger().log(Level.INFO, "UpHyperToolAction: configFileName: " + configFileName);
        try {
            this.myToolServices.startHyperTool(configFileName, props);
        }
        catch (Exception ex) {
            MessageDialogFactory.createMessageDialog((String)("It was not possible to start " + toolName), (Exception)ex, (boolean)false, null).setVisible(true);
        }
    }

    private int getUpgradePackageIdColumn() {
        TableColumnModel colModel = this.myUpTable.getTableHeader().getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            String colName = this.myUpTable.getColumnName(i);
            if (!colName.equals(UPGRADE_PACKAGE_ID)) continue;
            return i;
        }
        return -1;
    }
}

