/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emas.sm.applications.FanSelectController;
import se.ericsson.cello.emas.sm.applications.FanSelectView;
import se.ericsson.cello.emas.sm.services.FanNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Transaction;

public class EditFansActionController
extends AbstractApplicationController
implements ActionListener {
    FanSelectController controller = null;
    Vector slots = new Vector();
    private static final int TIME_OUT_PERIOD = 600;

    protected void init() {
        MOProxy[] fanSlotList = null;
        MOProxy[] fans = null;
        String fanName = null;
        TreeMap<String, MOProxy> selectedFans = new TreeMap<String, MOProxy>();
        MOProxy swa = new MOProxy((String)this.getParameter("LDNLIST"));
        TreeMap selectedRepertoires = new TreeMap();
        try {
            fanSlotList = (MOProxy[])swa.getAttribute("slotList", null);
            Vector<MOProxy> fanVector = new Vector<MOProxy>(0, 1);
            for (int i = 0; i < fanSlotList.length; ++i) {
                if (fanSlotList[i].getType().equals("Fan")) {
                    fanVector.add(fanSlotList[i]);
                }
                if (!fanSlotList[i].getType().equals("Slot")) continue;
                this.slots.add(fanSlotList[i]);
            }
            if (fanVector.size() != 0) {
                fans = fanVector.toArray(new MOProxy[0]);
                for (int count = 0; count < fans.length; ++count) {
                    fanName = FanNameFactory.getFanName(fans[count]);
                    selectedFans.put(fanName, fans[count]);
                }
            }
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "ERROR_EDIT_FANS", null);
            this.stopApp();
            return;
        }
        Object[][] params = new Object[][]{{"LDNLIST", this.getParameter("LDNLIST")}, {"FAN_LIST", selectedFans}};
        this.controller = (FanSelectController)this.startDialog(false, "EDIT_FANS_TITLE", null, FanSelectView.class, FanSelectController.class, params);
        this.controller.addActionListener(this);
    }

    public void setSelectedFans(TreeMap selectedFans) {
        NameValue[] nameValues = new NameValue[1];
        Object fanName = null;
        String ldn = (String)this.getParameter("LDNLIST");
        MOProxy swAllocationMo = new MOProxy(ldn);
        Transaction transaction = null;
        try {
            transaction = new Transaction(600);
            swAllocationMo.action("deleteAllSlots", new NameValue[0], transaction.session);
            Vector fans = new Vector(selectedFans.values());
            Enumeration enume = this.slots.elements();
            while (enume.hasMoreElements()) {
                fans.addElement(enume.nextElement());
            }
            nameValues[0] = new NameValue("param", (Object)fans.toArray(new MOProxy[0]));
            swAllocationMo.action("addSlots", nameValues, transaction.session);
            transaction.commit();
            transaction.end();
        }
        catch (CSException e) {
            try {
                transaction.rollback();
                transaction.end();
            }
            catch (CSException cs) {
                Log.logError((String)"Rollback of the transaction failed", (Throwable)cs);
            }
            this.reportException((Exception)((Object)e), "ERROR_EDIT_FANS", null);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if ("OK".equals(event.getActionCommand())) {
            this.setSelectedFans(this.controller.getSelectedFans());
            if (this.controller.canDismiss()) {
                this.controller.stopDialog();
                this.getApplication().stopApplicationNoCheck();
            }
        } else if ("APPLY".equals(event.getActionCommand())) {
            this.setSelectedFans(this.controller.getSelectedFans());
        } else if ("CANCEL".equals(event.getActionCommand())) {
            this.getApplication().stopApplicationNoCheck();
        } else if ("ERROR".equals(event.getActionCommand())) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    private void stopApp() {
        final AbstractApplication application = this.getApplication();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                application.stopApplicationNoCheck();
            }
        });
    }
}

