/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import se.ericsson.cello.emas.sm.applications.LicenseLogicController;
import se.ericsson.cello.emas.sm.applications.LicenseLogicControllerImpl;
import se.ericsson.cello.emas.sm.applications.LicenseUpdateKeyFileView;
import se.ericsson.cello.support.gui.ErrorDialog;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;

public class LicenseUpdateKeyFileController
extends AbstractApplicationController
implements ActionListener {
    private static final String CLASS_NAME = "LicenseUpdateKeyFileController";
    private LicenseLogicController theLicensingMo = null;
    private static final String OK = "OK";
    private static final String APPLY = "APPLY";
    private static final String CANCEL = "CANCEL";
    protected static final int USER_ID_STRING_LEN = 20;
    protected static final int PSW_STRING_LEN = 20;
    protected static final int IP_ADDR_STRING_LEN = 16;
    protected static final int FILE_PATH_STRING_LEN = 256;
    private static final String GUI_VALUE_CHANGED = "GUI_VALUE_CHANGED";
    protected boolean bValueChanged = false;
    private LicenseUpdateKeyFileView updateKeyFileView;

    protected void init() {
        Log.logNotify((String)"LicenseUpdateKeyFileController.init()");
        try {
            this.getApplication().setTitle("UPDATE_LICENSE_KEY_FILE_TITLE", null);
            this.updateKeyFileView = (LicenseUpdateKeyFileView)this.getView();
            this.theLicensingMo = new LicenseLogicControllerImpl();
            this.updateKeyFileView.moHelpButton.putClientProperty((Object)"HELP_KEY", (Object)"class Licensing");
            this.updateKeyFileView.moHelpButton.putClientProperty((Object)"HELP_ENABLE", (Object)"");
            this.updateKeyFileView.moHelpButton.putClientProperty((Object)"TITLE", (Object)"YES");
            this.setButtonListeners();
            this.setActionListeners();
        }
        catch (Exception e) {
            this.reportException(e, "LICENSING_MO_ERROR_MSG", null);
            this.getApplication().stopApplication();
        }
    }

    protected void afterVisible() {
        this.updateKeyFileView.okButton.setEnabled(false);
        this.updateKeyFileView.applyButton.setEnabled(false);
        this.updateKeyFileView.cancelButton.setEnabled(true);
        this.updateKeyFileView.stringFieldUserName.setMandatory(false);
        this.updateKeyFileView.stringFieldPassword.setMandatory(false);
        this.updateKeyFileView.ipAddressFieldLicenseServer.setMandatory(true);
        this.updateKeyFileView.stringFieldLicenseFilePath.setMandatory(true);
    }

    private void setButtonListeners() {
        this.updateKeyFileView.okButton.setActionListener((ActionListener)this, OK);
        this.updateKeyFileView.applyButton.setActionListener((ActionListener)this, APPLY);
        this.updateKeyFileView.cancelButton.setActionListener((ActionListener)this, CANCEL);
    }

    private void setActionListeners() {
        this.updateKeyFileView.stringFieldUserName.setActionListener((ActionListener)this, GUI_VALUE_CHANGED);
        this.updateKeyFileView.stringFieldPassword.setActionListener((ActionListener)this, GUI_VALUE_CHANGED);
        this.updateKeyFileView.ipAddressFieldLicenseServer.setActionListener((ActionListener)this, GUI_VALUE_CHANGED);
        this.updateKeyFileView.stringFieldLicenseFilePath.setActionListener((ActionListener)this, GUI_VALUE_CHANGED);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals(GUI_VALUE_CHANGED)) {
            Log.logNotify((String)("LicenseUpdateKeyFileController.actionPerformed " + event.getActionCommand()));
            this.bValueChanged = true;
            this.updateKeyFileView.applyButton.setEnabled(this.checkMandatoryFields());
            this.updateKeyFileView.okButton.setEnabled(this.checkMandatoryFields());
        } else if (event.getActionCommand().equals(OK)) {
            Log.logNotify((String)("LicenseUpdateKeyFileController.actionPerformed " + event.getActionCommand()));
            if (this.checkMandatoryFields() && this.bValueChanged) {
                if (!this.validateGuiValues()) {
                    return;
                }
                if (this.updateLicenseMoKeyFile()) {
                    this.getApplication().stopApplication();
                }
            }
        } else if (event.getActionCommand().equals(APPLY)) {
            Log.logNotify((String)("LicenseUpdateKeyFileController.actionPerformed " + event.getActionCommand()));
            if (this.checkMandatoryFields()) {
                if (!this.validateGuiValues()) {
                    return;
                }
                this.updateLicenseMoKeyFile();
            }
            this.updateKeyFileView.applyButton.setEnabled(false);
            this.bValueChanged = false;
        } else if (event.getActionCommand().equals(CANCEL)) {
            Log.logNotify((String)("LicenseUpdateKeyFileController.actionPerformed " + event.getActionCommand()));
            this.getApplication().stopApplication();
        }
    }

    private boolean checkMandatoryFields() {
        boolean check = false;
        if (this.updateKeyFileView.ipAddressFieldLicenseServer.isFilledIn() && this.updateKeyFileView.stringFieldLicenseFilePath.isFilledIn()) {
            check = true;
        }
        return check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateGuiValues() {
        String psw;
        String errorMessage = null;
        SyntaxException exep = null;
        String userId = this.updateKeyFileView.stringFieldUserName.getValue();
        if (userId != null && userId.length() > 20) {
            errorMessage = "USER_ID_STRING_TOO_LONG";
        }
        if ((psw = this.updateKeyFileView.stringFieldPassword.getValue()) != null && psw.length() > 20) {
            errorMessage = "PASSWORD_STRING_TOO_LONG";
        }
        try {
            try {
                String ipAddr = this.updateKeyFileView.ipAddressFieldLicenseServer.getValue();
                if (ipAddr != null && ipAddr.length() > 16) {
                    errorMessage = "IP_ADDR_STRING_TOO_LONG";
                }
            }
            catch (SyntaxException e) {
                errorMessage = "WRONG_SYNTAX_IN_IP_ADDR";
                exep = e;
                Object var7_8 = null;
                String filePath = this.updateKeyFileView.stringFieldLicenseFilePath.getValue();
                if (filePath != null && filePath.length() > 256) {
                    errorMessage = "LICENSE_FILE_PATH_STRING_TOO_LONG";
                }
                if (errorMessage == null) return true;
                if (null != exep) {
                    this.reportException((Exception)((Object)exep), errorMessage, null);
                    return false;
                }
                ErrorDialog errDia = ErrorDialog.create((Component)this.getView(), (String)this.getString(errorMessage, null), null);
                errDia.show();
                return false;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            String filePath = this.updateKeyFileView.stringFieldLicenseFilePath.getValue();
            if (filePath != null && filePath.length() > 256) {
                errorMessage = "LICENSE_FILE_PATH_STRING_TOO_LONG";
            }
            if (errorMessage == null) return true;
            if (null != exep) {
                this.reportException((Exception)((Object)exep), errorMessage, null);
                return false;
            }
            ErrorDialog errDia = ErrorDialog.create((Component)this.getView(), (String)this.getString(errorMessage, null), null);
            errDia.show();
            return false;
        }
        String filePath = this.updateKeyFileView.stringFieldLicenseFilePath.getValue();
        if (filePath != null && filePath.length() > 256) {
            errorMessage = "LICENSE_FILE_PATH_STRING_TOO_LONG";
        }
        if (errorMessage == null) return true;
        if (null != exep) {
            this.reportException((Exception)((Object)exep), errorMessage, null);
            return false;
        }
        ErrorDialog errDia = ErrorDialog.create((Component)this.getView(), (String)this.getString(errorMessage, null), null);
        errDia.show();
        return false;
    }

    private boolean updateLicenseMoKeyFile() {
        Log.logNotify((String)"LicenseUpdateKeyFileController.updateLicenseMoKeyFile ");
        try {
            String userId = this.updateKeyFileView.stringFieldUserName.getValue();
            String psw = this.updateKeyFileView.stringFieldPassword.getValue();
            String ipAddr = this.updateKeyFileView.ipAddressFieldLicenseServer.getValue();
            String filePath = this.updateKeyFileView.stringFieldLicenseFilePath.getValue();
            this.theLicensingMo.actionUpdateLicenseKeyFile(userId, psw, ipAddr, filePath);
            return true;
        }
        catch (SyntaxException syntaxErr) {
            this.reportException((Exception)((Object)syntaxErr), "WRONG_SYNTAX_IN_IP_ADDR", null);
            return false;
        }
        catch (Exception e) {
            this.reportException(e, "LICENSING_MO_ERROR_MSG", null);
            return false;
        }
    }
}

