/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import se.ericsson.cello.emas.sm.applications.RestoreSlide5ConfirmWizardView;
import se.ericsson.cello.emas.sm.applications.RestoreSlidesController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.RestoreConfirm;
import se.ericsson.cello.support.mgr.TimeConverter;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class RestoreSlide5ConfirmWizardController
extends RestoreSlidesController
implements MOProxy.MOListener {
    private RestoreSlide5ConfirmWizardView view;
    private String confirmationRestoreDeadline = "emptyDateTime";

    protected void init() {
        this.view = (RestoreSlide5ConfirmWizardView)this.getView();
        Object[] args = new Object[]{this.getCurrentLoadedCvName(), this.getFirstCvInRollBackList()};
        this.view.setInfoJTextArea(this.getString("RESTORE_INFO_TEXT_WIZARD_SLIDE5", args));
        configurationVersionMo = RestoreConfirm.getConfigurationVersionMo();
        try {
            if (configurationVersionMo != null && configurationVersionMo.isExisting()) {
                configurationVersionMo.addMOListener((MOProxy.MOListener)this);
            }
        }
        catch (CSException e) {
            Log.logError((String)"Error getting MO configurationVersionMo", (Throwable)e);
            this.reportException((Exception)((Object)e), "", null);
        }
    }

    public void attributesChanged(MOProxy anMO, NameValue[] someAttributes) {
        Log.trace((String)"------  method attributesChanged in class RestoreSlide5ConfirmWizardController");
        try {
            for (int i = 0; i < someAttributes.length; ++i) {
                if (!someAttributes[i].name.equals("restoreConfirmationDeadline")) continue;
                this.confirmationRestoreDeadline = (String)someAttributes[i].value;
                this.setDeadLine(this.confirmationRestoreDeadline);
            }
        }
        catch (Exception e) {
            Log.logError((String)"Error getting attribute", (Throwable)e);
            this.reportException(e, "ERROR_GET", null);
        }
    }

    protected boolean finish() {
        this.setFinishEnabled(false);
        this.view.setConfirmRadioButtonEnabled(false);
        try {
            if (configurationVersionMo != null && configurationVersionMo.isExisting()) {
                NameValue[] NO_ARGUMENTS = new NameValue[]{};
                if (this.confirmRestoreSelected()) {
                    configurationVersionMo.action("confirmRestore", NO_ARGUMENTS);
                } else {
                    configurationVersionMo.action("cancelRestore", NO_ARGUMENTS);
                }
                configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
            }
        }
        catch (CSException e) {
            Log.logError((String)"Error sending confirmRestore/cancelRestore action", (Throwable)e);
            this.reportException((Exception)((Object)e), "", null);
            this.letTheUserTryAgain();
            return false;
        }
        return true;
    }

    protected Class getNextViewClass() {
        return null;
    }

    protected Class getNextControllerClass() {
        return null;
    }

    protected void beforeVisible() {
        this.setWizardTitle("CV_RESTORE_WIZARD_SLIDE_5", new Object[]{this.getCurrentLoadedCvName()});
        this.setCancelVisible(false);
        this.setCloseVisible(true);
        this.requestFocusNextButton();
        this.setNextAsDefaultButton();
        this.setPreviousEnabled(false);
        try {
            if (configurationVersionMo == null) {
                configurationVersionMo = RestoreConfirm.getConfigurationVersionMo();
            }
            if (configurationVersionMo != null && configurationVersionMo.isExisting()) {
                this.confirmationRestoreDeadline = (String)configurationVersionMo.getAttribute("restoreConfirmationDeadline");
            }
        }
        catch (Exception e) {
            Log.logError((String)"Error getting attribute confirmationRestoreDeadline", (Throwable)e);
            this.reportException(e, "ERROR_GET", null);
        }
        this.setDeadLine(this.confirmationRestoreDeadline);
    }

    private void setDeadLine(String confirmationRestoreDeadline) {
        confirmationRestoreDeadline = confirmationRestoreDeadline != null && !confirmationRestoreDeadline.equals("") ? new TimeConverter().formatTime(confirmationRestoreDeadline) : this.getString("RESTORECONFIRMATIONDEADLINE_ATTRIBUTE_IS_EMPTY", null);
        this.view.setConfirmationRestoreDeadLine(confirmationRestoreDeadline);
    }

    protected boolean close() {
        if (configurationVersionMo != null) {
            configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        }
        return true;
    }

    protected void viewClosing() {
        if (configurationVersionMo != null) {
            configurationVersionMo.removeMOListener((MOProxy.MOListener)this);
        }
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private boolean confirmRestoreSelected() {
        return this.view.getConfirmationRadioButtonValue().equals(this.view.CONFIRM_RESTORE_SELECTED);
    }

    private void letTheUserTryAgain() {
        this.setFinishEnabled(true);
        this.view.setConfirmRadioButtonEnabled(true);
    }

    private String getFirstCvInRollBackList() {
        String[] rollbackList = null;
        if (configurationVersionMo == null) {
            configurationVersionMo = RestoreConfirm.getConfigurationVersionMo();
        }
        try {
            rollbackList = (String[])configurationVersionMo.getAttribute("rollbackList");
        }
        catch (Exception e) {
            Log.logError((String)"Error getting RBL name", (Throwable)e);
            this.reportException(e, "", null);
        }
        if (rollbackList == null) {
            return this.getString("THE_ROLLBACKLIST_IS_EMPTY", null);
        }
        if (rollbackList.length == 0) {
            return this.getString("THE_ROLLBACKLIST_IS_EMPTY", null);
        }
        if (rollbackList[0].equals("")) {
            return this.getString("THE_ROLLBACKLIST_IS_EMPTY", null);
        }
        return rollbackList[0];
    }

    private String getCurrentLoadedCvName() {
        String currentLoadedCV = null;
        if (configurationVersionMo == null) {
            configurationVersionMo = RestoreConfirm.getConfigurationVersionMo();
        }
        try {
            currentLoadedCV = (String)configurationVersionMo.getAttribute("currentLoadedConfigurationVersion");
        }
        catch (Exception e) {
            Log.logError((String)"Error getting CURRENTLOADEDCONFIGURATIONVERSION_NAME", (Throwable)e);
            this.reportException(e, "", null);
        }
        if (currentLoadedCV == null || currentLoadedCV.equals("")) {
            return this.getString("CURRENTLOADED_CV_ATTRIBUTE_IS_EMPTY", null);
        }
        return currentLoadedCV;
    }

    public void childDeleted(MOProxy childMO) {
    }

    public void childCreated(MOProxy childMO) {
    }
}

