/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emas.sm.applications.HardSoftSelection;
import se.ericsson.cello.emas.sm.applications.UpgradePackageController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;

public class UpgradePackageUpgradeController
extends AbstractApplicationController {
    private MOProxy upgradePackageMo;
    private static final NameValue[] NO_ARGS = new NameValue[0];
    private String filePath = "";
    private String ftpServer = "";
    private static final int UPGRADE_TIMEOUT = 5000;
    private String defaultButton = "";
    private boolean rebootNodeUpgradeAllowed = false;
    private boolean upgradeAllowed = false;
    private String message = "";
    private Object[] messageArgs;

    protected void init() {
        String ldn = (String)this.getParameter("LDNLIST");
        this.upgradePackageMo = new MOProxy(ldn);
        try {
            boolean isParameterOk;
            boolean bl = isParameterOk = ldn != null && !ldn.equals("") && this.upgradePackageMo != null && this.upgradePackageMo.isExisting() && this.upgradePackageMo.getType().equals("UpgradePackage");
            if (isParameterOk) {
                int value;
                this.filePath = (String)this.upgradePackageMo.getAttribute("upFilePathOnFtpServer");
                this.messageArgs = new Object[]{this.filePath};
                Object[] buttons = this.getButtons();
                if (buttons != null && (value = JOptionPane.showOptionDialog(null, this.message, this.getString("UP_UPGRADE_CONFIRM_TITLE", null), 0, 3, null, buttons, this.defaultButton)) != -1) {
                    HardSoftSelection selection = buttons.length == 3 ? HardSoftSelection.get(value) : (value == 0 ? (this.rebootNodeUpgradeAllowed ? HardSoftSelection.HARD : HardSoftSelection.SOFT) : HardSoftSelection.CANCEL);
                    if (selection != HardSoftSelection.CANCEL) {
                        this.upgradeNodeWithUpgradePackage(selection);
                    }
                }
            } else {
                Log.logError((String)("Illegal argument to UpgradePackageUpgradeController: LDNLIST=" + ldn));
            }
        }
        catch (Exception e) {
            this.reportException(e, "ERROR_GET", null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpgradePackageUpgradeController.this.localStopApplication();
            }
        });
    }

    private void localStopApplication() {
        this.getApplication().stopApplicationNoCheck();
    }

    public void upgradeNodeWithUpgradePackage(HardSoftSelection typeSelection) {
        if (typeSelection == HardSoftSelection.CANCEL) {
            return;
        }
        Object upgradeTransaction = null;
        try {
            String upgradeAction = typeSelection == HardSoftSelection.HARD ? "rebootNodeUpgrade" : "upgrade";
            Object result = this.upgradePackageMo.action(upgradeAction, NO_ARGS, null);
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_UPGRADE_ERROR_MSG", null);
            UpgradePackageController.finishFailedTransaction((AbstractController)this, null, "Upgrade failed on " + this.upgradePackageMo.getDN(), (Exception)((Object)e));
            return;
        }
    }

    protected void viewClosing() {
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private String[] getButtons() throws Exception {
        String[] myButtons = new String[]{this.getString("UP_SOFT_UPGRADE", null), this.getString("UP_HARD_UPGRADE", null), this.getString("GSL_CANCEL", null)};
        this.defaultButton = this.getString("UP_SOFT_UPGRADE", null);
        this.rebootNodeUpgradeAllowed = false;
        this.upgradeAllowed = false;
        try {
            Struct supportedUpgradeType = (Struct)this.upgradePackageMo.action("readSupportedUpgradeTypesStatus", NO_ARGS, null);
            this.rebootNodeUpgradeAllowed = (Boolean)supportedUpgradeType.getElementValue("rebootNodeUpgrade");
            this.upgradeAllowed = (Boolean)supportedUpgradeType.getElementValue("upgrade");
        }
        catch (CSException e) {
            this.reportException((Exception)((Object)e), "UP_READSTATUS_ERROR", null);
        }
        if (this.rebootNodeUpgradeAllowed && this.upgradeAllowed) {
            this.message = this.getString("UP_UPGRADE_CONFIRM_MSG", this.messageArgs) + this.getString("UP_UPGRADE_SOFT", null) + this.getString("UP_UPGRADE_HARD", null);
            return myButtons;
        }
        if (this.rebootNodeUpgradeAllowed) {
            this.message = this.getString("UP_UPGRADE_CONFIRM_MSG", this.messageArgs) + this.getString("UP_UPGRADE_HARD", null);
            myButtons = new String[]{this.getString("UP_HARD_UPGRADE", null), this.getString("GSL_CANCEL", null)};
            this.defaultButton = this.getString("UP_HARD_UPGRADE", null);
            return myButtons;
        }
        if (this.upgradeAllowed) {
            this.message = this.getString("UP_UPGRADE_CONFIRM_MSG", this.messageArgs) + this.getString("UP_UPGRADE_SOFT", null);
            myButtons = new String[]{this.getString("UP_SOFT_UPGRADE", null), this.getString("GSL_CANCEL", null)};
            return myButtons;
        }
        myButtons = new String[]{this.getString("GSL_CANCEL", null)};
        return myButtons;
    }
}

