/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.cello.emas.sm.elements.EmasElementCreator;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class RepertoireElementCreator
extends EmasElementCreator {
    private MOProxy swAllocation = null;

    public RepertoireElementCreator(Properties p) {
        super(p);
    }

    public void dispose() {
        if (this.swAllocation != null) {
            this.swAllocation.removeMOListener((MOProxy.MOListener)this);
        }
    }

    public AbstractViewElement[] createInstances(AbstractViewElement parent) {
        MOProxy[] repertoireList = null;
        Vector<EmasViewElementInterface> newElements = new Vector<EmasViewElementInterface>();
        EmasViewElementInterface parentElement = (EmasViewElementInterface)parent;
        this.swAllocation = ((EmasViewElement)parentElement).getMO("SwAllocation");
        String dn = this.swAllocation.getDN();
        Log.trace((String)("parent LDN=" + this.swAllocation.getDN()));
        if (this.parentElements.containsKey(dn)) {
            Log.trace((String)"already subscribed");
        } else {
            this.parentElements.put(dn, parentElement);
            this.swAllocation.addMOListener((MOProxy.MOListener)this);
            Log.trace((String)("addMOListener to LDN=" + this.swAllocation.getDN()));
        }
        try {
            repertoireList = (MOProxy[])this.swAllocation.getAttribute("repertoireList", null);
        }
        catch (CSException e) {
            Log.logError((String)(((Object)((Object)this)).getClass().getName() + "::createInstances failed"), (Throwable)e);
            return newElements.toArray(new AbstractViewElement[0]);
        }
        for (int index = 0; index < repertoireList.length; ++index) {
            if (!repertoireList[index].getType().equals("Repertoire")) continue;
            EmasViewElementInterface newElement = null;
            try {
                newElement = this.createRepertoireElement(repertoireList[index]);
                if (newElement == null) continue;
                newElements.add(newElement);
                this.addElement(newElement);
                continue;
            }
            catch (Exception e) {
                Log.logError((String)("Repertoire Element " + this.getClassName() + " could not be created"), (Throwable)e);
            }
        }
        return newElements.toArray(new AbstractViewElement[0]);
    }

    public void attributesChanged(MOProxy anMO, NameValue[] nameValue) {
        AbstractViewElement swa = (AbstractViewElement)this.parentElements.get(anMO.getDN());
        MOProxy[] repertoireList = null;
        try {
            for (int i = 0; i < nameValue.length; ++i) {
                if (!nameValue[i].name.equals("repertoireList")) continue;
                repertoireList = Array.getLength(nameValue[i].value) > 0 ? (MOProxy[])nameValue[i].value : new MOProxy[]{};
                this.updateSwAllocation(swa, repertoireList);
            }
        }
        catch (Exception e) {
            Log.logError((String)"update failed", (Throwable)e);
        }
    }

    private void updateSwAllocation(AbstractViewElement swa, MOProxy[] repertoireList) {
        if (repertoireList != null) {
            AbstractViewElement[] children = swa.getChildren();
            Vector<MOProxy> repertoires = new Vector<MOProxy>(Arrays.asList(repertoireList));
            for (int i = 0; i < children.length; ++i) {
                if (((EmasViewElement)children[i]).getMO("Repertoire") == null) continue;
                if (repertoires.contains(((EmasViewElement)children[i]).getMO("Repertoire"))) {
                    repertoires.remove(((EmasViewElement)children[i]).getMO("Repertoire"));
                    continue;
                }
                swa.removeChild(children[i]);
                this.deleteElement((EmasViewElementInterface)children[i]);
            }
            MOProxy[] newRepertoires = repertoires.toArray(new MOProxy[0]);
            for (int i = 0; i < newRepertoires.length; ++i) {
                EmasViewElementInterface newElement = this.createRepertoireElement(newRepertoires[i]);
                swa.addChild((AbstractViewElement)newElement);
                this.addElement(newElement);
            }
        }
    }

    private EmasViewElementInterface createRepertoireElement(MOProxy repertoire) {
        EmasViewElementInterface newElement = null;
        try {
            MOComposite moc = new MOComposite();
            moc.add(repertoire);
            this.childElements = new Hashtable();
            MOProxy childElement = repertoire;
            String key = repertoire.getDN();
            this.childElements.put(key, childElement);
            Object[] args = new Object[]{moc, this.getProperties(), this};
            Class<?> c = Class.forName(this.getClassName());
            Vector v = new Vector();
            for (int i = 0; i < args.length; ++i) {
                v.add(args[i].getClass());
            }
            Constructor<?> constructor = c.getConstructor(v.toArray(new Class[0]));
            newElement = (EmasViewElementInterface)constructor.newInstance(args);
        }
        catch (Exception e) {
            Log.logError((String)("Repertoire Element " + this.getClassName() + " could not be created"), (Throwable)e);
        }
        return newElement;
    }
}

