/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmapplication;

import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.crbs.cat.pmcommon.PmBaseState;
import se.ericsson.crbs.cat.pmcommon.PmBaseStateMachine;
import se.ericsson.crbs.cat.pmcommon.PmClassCounter;
import se.ericsson.crbs.cat.pmcommon.PmLists;
import se.ericsson.crbs.cat.pmcommon.PmMaps;
import se.ericsson.crbs.cat.pmcommon.PmQueues;
import se.ericsson.crbs.cat.pminstantcounters.PmInstantCountersHandler;
import se.ericsson.crbs.cat.pmpms.PmMeasuredDataI;
import se.ericsson.crbs.cat.pmpms.PmMeasuredInstantData;
import se.ericsson.crbs.cat.pmpms.PmScannerI;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;

public class PmApplicationController
extends PmBaseStateMachine
implements Runnable {
    private final Callback m_callback;
    private final PmQueues.JobQueue m_jobQueue = new PmQueues.JobQueue();
    private final PmQueues.JobQueue m_instantJobQueue = new PmQueues.JobQueue();
    private final PmMaps.PmScannerMap m_scannerMap = new PmMaps.PmScannerMap();
    private Job m_currentJob = null;
    private int m_currentReportingSeqNo = -1;
    public final int JobInit_Started = 256;
    public final int JobInit_Skip = 257;
    public final int JobInit_Error = 511;

    public PmApplicationController(Callback callback) {
        super(State.Setup_Initial, State.Terminated_Fault);
        this.enter("PmApplicationController");
        this.m_callback = callback;
    }

    public void init() {
        this.enter("init");
        if (!this.validateState(State.Setup_Initial)) {
            return;
        }
        if (!this.updateState(State.Setup_Initial, State.Setup_AwaitingCounters)) {
            return;
        }
    }

    public void mopplet_applicationStarted() {
        this.enter("mopplet_applicationStarted");
    }

    public void mopplet_pmServiceStarted() {
        this.enter("mopplet_pmServiceStarted");
        this.m_callback.applicationController_mopplet_startThread(this, "PmApplicationController");
    }

    public void run() {
        this.enter("run");
        this.m_callback.applicationController_listenToSignals();
    }

    public boolean countersRegistered() {
        this.enter("countersRegistered");
        if (!this.checkState(State.Setup_AwaitingCounters)) {
            return false;
        }
        this.m_callback.applicationController_startCounterRegistrationDeadlineTimer(5000);
        return true;
    }

    public boolean startupDeadlineReached() {
        this.enter("startupDeadlineReached");
        if (!this.validateState(State.Setup_AwaitingCounters)) {
            return false;
        }
        if (!this.updateState(State.Setup_AwaitingCounters, State.Running_Awaiting)) {
            return true;
        }
        return true;
    }

    private void traceClassCounterSets(PmClassCounter[] classCounters) {
        this.enter("traceClassCounterSets");
        for (int outer = 0; outer < classCounters.length; ++outer) {
            PmClassCounter classCounter = classCounters[outer];
            this.general("MO class: " + classCounter.moClassName);
            PmClassCounter.PmCounter[] counters = classCounter.counters;
            for (int inner = 0; inner < counters.length; ++inner) {
                PmClassCounter.PmCounter counter = counters[inner];
                this.general("Counter: " + counter.counterName);
            }
        }
    }

    public boolean addScanner(PmScannerI scanner) {
        this.enter("addScanner");
        if (scanner == null) {
            this.error("scanner is null");
            return false;
        }
        int scannerId = scanner.getScannerId();
        boolean inserted = this.m_scannerMap.add(scannerId, scanner);
        if (!inserted) {
            this.abnormal("Scanner with id: " + scannerId + " already exists");
            return false;
        }
        return true;
    }

    public int removeScanner(int scannerId) {
        this.enter("removeScanner");
        if (!this.m_scannerMap.remove(scannerId)) {
            this.error("PmScanner with id: " + scannerId + " doesn't exist in PmApplicationController");
        }
        return this.m_scannerMap.size();
    }

    public PmClassCounter[] getActiveCountersFromScanners() {
        this.enter("getActiveCountersFromScanners");
        PmLists.PmClassCounterList allActive = new PmLists.PmClassCounterList();
        PmScannerI[] scanners = this.m_scannerMap.getValues();
        for (int scannerIdx = 0; scannerIdx < scanners.length; ++scannerIdx) {
            PmClassCounter[] scannerActiveCounters = scanners[scannerIdx].getActiveCounters();
            for (int classCntIdx = 0; classCntIdx < scannerActiveCounters.length; ++classCntIdx) {
                allActive.add(scannerActiveCounters[classCntIdx]);
            }
        }
        return allActive.toArray();
    }

    public boolean activateScannerCounters(PmClassCounter[] activatedClassCounters) {
        this.enter("activateScannerCounters");
        this.addJob(new ActivateCountersJob(activatedClassCounters));
        return true;
    }

    public boolean deactivateScannerCounters(PmClassCounter[] deactivedClassCounters) {
        this.enter("deactivateScannerCounters");
        this.addJob(new DeactivateCountersJob(deactivedClassCounters));
        return true;
    }

    public boolean reportScannerCounters(DataConsumer consumer, boolean enableCounters, int seqNo, PmClassCounter[] classCounters) {
        this.enter("reportScannerCounters");
        if (!this.isBetweenStates(State.Running_Begin, State.Running_End)) {
            this.info("Report job skipped as we are not in a running state yet");
            return false;
        }
        if (enableCounters) {
            this.general("Counters connected to newly added Scanner are enabled!");
            this.m_callback.applicationController_enableCounters(classCounters);
        }
        if (this.isBetweenStates(State.Running_Job_FreezingCounters, State.Running_Job_ReportingCounters)) {
            this.debug("Report job is already running for sequence number: " + this.m_currentReportingSeqNo);
            return false;
        }
        this.addJob(new ReportCountersJob(consumer, seqNo));
        return true;
    }

    public void reportInstantCounters(String moLDN, String moClassName, String[] counterNames, PmInstantCountersHandler.InstantCounterReceiver receiver) {
        this.enter("reportInstantCounters");
        this.addInstantJob(new ReportInstantCountersJob(moLDN, moClassName, counterNames, receiver));
    }

    public boolean allSessionsAreDoneUpdatingActive() {
        this.enter("allSessionsAreDoneUpdatingActive");
        if (!this.validateStateRange(State.Running_Job_Begin, State.Running_Job_End)) {
            return false;
        }
        return this.m_currentJob.allSessionsAreDoneUpdatingActive();
    }

    public boolean allSessionsAreDoneFreezing() {
        this.enter("allSessionsAreDoneFreezing");
        if (!this.validateStateRange(State.Running_Job_Begin, State.Running_Job_End)) {
            return false;
        }
        return this.m_currentJob.allSessionsAreDoneFreezing();
    }

    public boolean reportCounterValues(PmMeasuredDataI[] measurements, boolean dataToReport) {
        this.enter("reportCounterValues");
        if (!this.validateStateRange(State.Running_Job_Begin, State.Running_Job_End)) {
            return false;
        }
        MeasuredData[] measuredDataArray = new MeasuredData[measurements.length];
        for (int idx = 0; idx < measurements.length; ++idx) {
            measuredDataArray[idx] = measurements[idx].getMeasuredData();
        }
        return this.m_currentJob.reportCounterValues(measuredDataArray, dataToReport);
    }

    public boolean reportInstantCounterValues(PmMeasuredInstantData measuredInstantData) {
        this.enter("reportInstantCounterValues");
        if (!this.validateStateRange(State.Running_Job_Begin, State.Running_Job_End)) {
            return false;
        }
        return this.m_currentJob.reportInstantCounterValues(measuredInstantData);
    }

    public boolean allSessionsAreDoneReporting() {
        this.enter("allSessionsAreDoneReporting");
        if (!this.validateStateRange(State.Running_Job_Begin, State.Running_Job_End)) {
            return false;
        }
        return this.m_currentJob.allSessionsAreDoneReporting();
    }

    public boolean allSessionsAreDoneReportingInstantCounters() {
        this.enter("allSessionsAreDoneReportingInstantCounters");
        if (!this.validateStateRange(State.Running_Job_Begin, State.Running_Job_End)) {
            return false;
        }
        return this.m_currentJob.allSessionsAreDoneReportingInstantCounters();
    }

    public void checkJob() {
        this.enter("checkJob");
        if (!this.validateStateRange(State.Setup_AwaitingCounters, State.Running_End)) {
            return;
        }
        if (this.isAtState(State.Setup_AwaitingCounters)) {
            this.debug("Job not started as we are awaiting counters");
            return;
        }
        if (this.isBetweenStates(State.Running_Job_Begin, State.Running_Job_End)) {
            this.debug("Job is running: " + this.getCurrentState().toString());
            return;
        }
        boolean stdLaunchSuccess = this.launchJob(this.m_jobQueue, "Standard jobs");
        if (!stdLaunchSuccess) {
            this.launchJob(this.m_instantJobQueue, "Instant jobs");
        }
    }

    public boolean launchJob(PmQueues.JobQueue jobQueue, String queueName) {
        this.enter("launchJob");
        this.debug("Jobs in " + queueName + " queue: " + jobQueue.size());
        boolean cont = true;
        while (cont && jobQueue.size() > 0) {
            Job job = jobQueue.pop();
            String description = job.description();
            int jobInit = job.init();
            if (jobInit == 256) {
                cont = false;
                this.m_currentJob = job;
                this.debug("Started job: " + description);
                int timeout = job.getTimeoutInMs();
                this.m_callback.applicationController_startJobTimer(timeout);
                continue;
            }
            if (jobInit == 257) {
                this.debug("Skipped job: " + description);
                continue;
            }
            this.error("Failed to initialize job: " + description);
        }
        this.debug("Remaining jobs in " + queueName + " queue " + jobQueue.size());
        return !cont;
    }

    public void addInstantJob(Job instantJob) {
        this.enter("addInstantJob");
        if (instantJob == null) {
            return;
        }
        String description = instantJob.description();
        this.debug("Enqueued instant job: " + description);
        this.m_instantJobQueue.push(instantJob);
        this.checkJob();
    }

    public void addJob(Job job) {
        this.enter("addJob");
        if (job == null) {
            return;
        }
        String description = job.description();
        this.debug("Enqueued job: " + description);
        this.m_jobQueue.push(job);
        this.checkJob();
    }

    public boolean jobTimeoutReached() {
        this.enter("jobTimeoutReached");
        if (!this.validateStateRange(State.Running_Job_Begin, State.Running_Job_End)) {
            return false;
        }
        this.m_currentJob.onTimeout();
        return true;
    }

    protected boolean onValidateState(PmBaseState currentState) {
        this.enter("onValidateState");
        if (State.Running_Awaiting.toInt() == currentState.toInt() && this.m_currentJob != null) {
            this.error("m_currentJob should be null when state is State.Running_Awaiting");
            this.terminate();
            return false;
        }
        if (State.Running_Job_Begin.toInt() <= currentState.toInt() && currentState.toInt() <= State.Running_Job_End.toInt() && this.m_currentJob == null) {
            this.error("m_currentJob should not be null when state is between State.Running_Job_Begin and State.Running_Job_End");
            this.terminate();
            return false;
        }
        return true;
    }

    protected boolean onUpdateState(PmBaseState from, PmBaseState to) {
        this.enter("onUpdateState");
        if (to.toInt() == State.Running_Awaiting.toInt()) {
            this.m_currentJob = null;
            this.checkJob();
            return true;
        }
        return true;
    }

    public State getState() {
        return (State)this.getCurrentState();
    }

    public static class State
    extends PmBaseState {
        public static final State Setup_Initial = new State(0x510100);
        public static final State Setup_AwaitingCounters = new State(0x510110);
        public static final State Running_Begin = new State(5308928);
        public static final State Running_Awaiting = new State(5308928);
        public static final State Running_Job_Begin = new State(5309440);
        public static final State Running_Job_AddingScanner = new State(5309440);
        public static final State Running_Job_DeletingScanner = new State(5309456);
        public static final State Running_Job_ActivatingCounters = new State(5309472);
        public static final State Running_Job_DeactivatingCounters = new State(5309488);
        public static final State Running_Job_FreezingCounters = new State(5309504);
        public static final State Running_Job_ReportingCounters = new State(5309520);
        public static final State Running_Job_ReportingInstantCounters = new State(5309536);
        public static final State Running_Job_End = new State(5310464);
        public static final State Running_End = new State(5310464);
        public static final State Terminated_Fault = new State(0x51FFFF);

        public State(int state) {
            super(state);
        }
    }

    public class ReportInstantCountersJob
    extends BaseJob {
        private String m_moLDN;
        private String m_moClassName;
        private String[] m_counterNames;
        private PmInstantCountersHandler.InstantCounterReceiver m_receiver;

        public ReportInstantCountersJob(String moLDN, String moClassName, String[] counterNames, PmInstantCountersHandler.InstantCounterReceiver receiver) {
            super("ReportInstantCountersJob");
            PmApplicationController.this.enter("ReportInstantCountersJob");
            this.m_moLDN = moLDN;
            this.m_moClassName = moClassName;
            this.m_counterNames = counterNames;
            this.m_receiver = receiver;
        }

        public int init() {
            PmApplicationController.this.enter("ReportInstantCountersJob.init");
            if (!PmApplicationController.this.validateState(State.Running_Awaiting)) {
                return 511;
            }
            PmApplicationController.this.general("Begin reporting instant counters");
            if (!PmApplicationController.this.m_callback.applicationController_reportInstantCountersEvent(this.m_moLDN, this.m_moClassName, this.m_counterNames)) {
                long[][] measurements = new long[this.m_counterNames.length][1];
                for (int i = 0; i < measurements.length; ++i) {
                    measurements[i][0] = -2L;
                }
                this.m_receiver.receiveInstantCounters(new PmMeasuredInstantData(measurements, null));
                return 257;
            }
            if (!PmApplicationController.this.updateState(State.Running_Awaiting, State.Running_Job_ReportingInstantCounters)) {
                return 511;
            }
            return 256;
        }

        public boolean reportInstantCounterValues(PmMeasuredInstantData measuredInstantData) {
            PmApplicationController.this.enter("ReportInstantCountersJob.reportInstantCounterValues");
            if (!PmApplicationController.this.validateState(State.Running_Job_ReportingInstantCounters)) {
                return false;
            }
            PmApplicationController.this.general("Reporting instant counter measurements");
            this.m_receiver.receiveInstantCounters(measuredInstantData);
            return true;
        }

        public boolean allSessionsAreDoneReportingInstantCounters() {
            PmApplicationController.this.enter("ReportInstantCountersJob.allSessionsAreDoneReportingInstantCounters");
            if (!PmApplicationController.this.validateState(State.Running_Job_ReportingInstantCounters)) {
                return false;
            }
            PmApplicationController.this.general("Done reporting instant counters");
            if (!PmApplicationController.this.updateState(State.Running_Job_ReportingInstantCounters, State.Running_Awaiting)) {
                return false;
            }
            PmApplicationController.this.m_callback.applicationController_cancelJobTimer();
            return true;
        }

        public void onTimeout() {
            super.onTimeout();
            this.m_receiver.receiveInstantCounters(new PmMeasuredInstantData(null, (Exception)new ResourceUnavailableException("PmApplicationController", "Timeout while fetching instant counters")));
            this.allSessionsAreDoneReportingInstantCounters();
        }
    }

    public class ReportCountersJob
    extends BaseJob {
        private final DataConsumer m_consumer;
        private final int m_seqNo;

        public ReportCountersJob(DataConsumer consumer, int seqNo) {
            super("ReportCountersJob");
            PmApplicationController.this.enter("ReportCountersJob");
            this.m_consumer = consumer;
            this.m_seqNo = seqNo;
        }

        public int init() {
            PmApplicationController.this.enter("ReportCountersJob.init");
            if (!PmApplicationController.this.validateState(State.Running_Awaiting)) {
                return 511;
            }
            if (PmApplicationController.this.m_currentReportingSeqNo == this.m_seqNo) {
                PmApplicationController.this.general("Already reported counters for sequence number: " + this.m_seqNo);
                return 257;
            }
            if (!PmApplicationController.this.m_callback.applicationController_freezeCountersEvent()) {
                return 257;
            }
            PmApplicationController.this.m_currentReportingSeqNo = this.m_seqNo;
            PmApplicationController.this.general("Begin reporting counters for sequence number: " + this.m_seqNo);
            if (!PmApplicationController.this.updateState(State.Running_Awaiting, State.Running_Job_FreezingCounters)) {
                return 511;
            }
            return 256;
        }

        public boolean allSessionsAreDoneFreezing() {
            PmApplicationController.this.enter("ReportCountersJob.allSessionsAreDoneFreezing");
            if (!PmApplicationController.this.validateState(State.Running_Job_FreezingCounters)) {
                return false;
            }
            if (!PmApplicationController.this.updateState(State.Running_Job_FreezingCounters, State.Running_Job_ReportingCounters)) {
                return false;
            }
            return PmApplicationController.this.m_callback.applicationController_reportCountersEvent();
        }

        public boolean reportCounterValues(MeasuredData[] measurements, boolean dataToReport) {
            PmApplicationController.this.enter("ReportCountersJob.reportCounterValues");
            if (!PmApplicationController.this.validateState(State.Running_Job_ReportingCounters)) {
                return false;
            }
            if (dataToReport) {
                PmApplicationController.this.general("Pushing measurements for sequence number: " + this.m_seqNo);
                this.m_consumer.push(measurements, this.m_seqNo);
            } else {
                PmApplicationController.this.general("No measurement data exists for sequence number: " + this.m_seqNo);
            }
            return true;
        }

        public boolean allSessionsAreDoneReporting() {
            PmApplicationController.this.enter("ReportCountersJob.allSessionsAreDoneReporting");
            if (!PmApplicationController.this.validateState(State.Running_Job_ReportingCounters)) {
                return false;
            }
            PmApplicationController.this.general("Done reporting counters for sequence number: " + this.m_seqNo);
            if (!PmApplicationController.this.updateState(State.Running_Job_ReportingCounters, State.Running_Awaiting)) {
                return false;
            }
            PmApplicationController.this.m_callback.applicationController_cancelJobTimer();
            return true;
        }

        public void onTimeout() {
            super.onTimeout();
            if (!PmApplicationController.this.validateStates(new State[]{State.Running_Job_FreezingCounters, State.Running_Job_ReportingCounters})) {
                return;
            }
            PmBaseState currentState = PmApplicationController.this.getCurrentState();
            if (currentState == State.Running_Job_FreezingCounters) {
                this.allSessionsAreDoneFreezing();
            } else if (currentState == State.Running_Job_ReportingCounters) {
                this.allSessionsAreDoneReporting();
            }
        }
    }

    public class DeactivateCountersJob
    extends BaseCounterJob {
        public DeactivateCountersJob(PmClassCounter[] classCounters) {
            super("DeactivateCountersJob", classCounters);
            PmApplicationController.this.enter("DeactivateCountersJob");
        }

        public int init() {
            PmApplicationController.this.enter("DeactivateCountersJob.init");
            if (!PmApplicationController.this.validateState(State.Running_Awaiting)) {
                return 511;
            }
            PmApplicationController.this.traceClassCounterSets(this.classCounters());
            if (!PmApplicationController.this.m_callback.applicationController_deactivateCounters(this.classCounters())) {
                return 257;
            }
            if (!PmApplicationController.this.updateState(State.Running_Awaiting, State.Running_Job_DeactivatingCounters)) {
                return 511;
            }
            return 256;
        }

        public boolean allSessionsAreDoneUpdatingActive() {
            PmApplicationController.this.enter("DeactivateCountersJob.allSessionsAreDoneUpdatingActive");
            if (!PmApplicationController.this.validateState(State.Running_Job_DeactivatingCounters)) {
                return false;
            }
            if (!PmApplicationController.this.updateState(State.Running_Job_DeactivatingCounters, State.Running_Awaiting)) {
                return false;
            }
            PmApplicationController.this.m_callback.applicationController_cancelJobTimer();
            boolean resetCurrentSeqNo = PmApplicationController.this.m_scannerMap.isEmpty();
            PmScannerI[] scanners = PmApplicationController.this.m_scannerMap.getValues();
            for (int scannerIdx = 0; scannerIdx < scanners.length; ++scannerIdx) {
                PmScannerI scanner = scanners[scannerIdx];
                if (scanner == null) continue;
                resetCurrentSeqNo |= scanner.getActiveCounters().length == 0;
            }
            if (resetCurrentSeqNo) {
                PmApplicationController.this.general("No scanners are currently active, reset currentSeqNo");
                PmApplicationController.this.m_currentReportingSeqNo = -1;
            }
            return true;
        }

        public void onTimeout() {
            super.onTimeout();
            this.allSessionsAreDoneUpdatingActive();
        }
    }

    public class ActivateCountersJob
    extends BaseCounterJob {
        public ActivateCountersJob(PmClassCounter[] classCounters) {
            super("ActivateCountersJob", classCounters);
            PmApplicationController.this.enter("ActivateCountersJob");
        }

        public int init() {
            PmApplicationController.this.enter("ActivateCountersJob.init");
            if (!PmApplicationController.this.validateState(State.Running_Awaiting)) {
                return 511;
            }
            PmApplicationController.this.traceClassCounterSets(this.classCounters());
            if (!PmApplicationController.this.m_callback.applicationController_activateCounters(this.classCounters())) {
                return 257;
            }
            if (!PmApplicationController.this.updateState(State.Running_Awaiting, State.Running_Job_ActivatingCounters)) {
                return 511;
            }
            return 256;
        }

        public boolean allSessionsAreDoneUpdatingActive() {
            PmApplicationController.this.enter("ActivateCountersJob.allSessionsAreDoneUpdatingActive");
            if (!PmApplicationController.this.validateState(State.Running_Job_ActivatingCounters)) {
                return false;
            }
            if (!PmApplicationController.this.updateState(State.Running_Job_ActivatingCounters, State.Running_Awaiting)) {
                return false;
            }
            PmApplicationController.this.m_callback.applicationController_cancelJobTimer();
            return true;
        }

        public void onTimeout() {
            super.onTimeout();
            this.allSessionsAreDoneUpdatingActive();
        }
    }

    public abstract class BaseCounterJob
    extends BaseJob {
        private final PmClassCounter[] m_classCounters;

        protected BaseCounterJob(String description, PmClassCounter[] classCounters) {
            super(description);
            PmApplicationController.this.enter("BaseCounterJob");
            this.m_classCounters = classCounters;
        }

        protected PmClassCounter[] classCounters() {
            PmApplicationController.this.enter("BaseCounterJob.classCounters");
            return this.m_classCounters;
        }
    }

    public abstract class BaseJob
    implements Job {
        private final String m_description;
        protected int m_defaultTimeout = 5000;

        protected BaseJob(String description) {
            PmApplicationController.this.enter("BaseJob");
            this.m_description = description;
        }

        public String description() {
            PmApplicationController.this.enter("BaseJob.description");
            return this.m_description;
        }

        public boolean allSessionsAreDoneUpdatingActive() {
            PmApplicationController.this.enter("BaseJob.allSessionsAreDoneUpdatingActive");
            PmApplicationController.this.error("Unexpected call to allSessionsAreDoneUpdatingActive");
            return false;
        }

        public boolean allSessionsAreDoneFreezing() {
            PmApplicationController.this.enter("BaseJob.allSessionsAreDoneFreezing");
            PmApplicationController.this.error("Unexpected call to allSessionsAreDoneFreezing");
            return false;
        }

        public boolean reportCounterValues(MeasuredData[] measurements, boolean dataToReport) {
            PmApplicationController.this.enter("BaseJob.reportCounterValues");
            PmApplicationController.this.error("Unexpected call to reportCounterValues");
            return false;
        }

        public boolean reportInstantCounterValues(PmMeasuredInstantData measuredInstantData) {
            PmApplicationController.this.enter("BaseJob.reportInstantCounterValues");
            PmApplicationController.this.error("Unexpected call to reportInstantCounterValues");
            return false;
        }

        public boolean allSessionsAreDoneReporting() {
            PmApplicationController.this.enter("BaseJob.allSessionsAreDoneReporting");
            PmApplicationController.this.error("Unexpected call to allSessionsAreDoneReporting");
            return false;
        }

        public boolean allSessionsAreDoneReportingInstantCounters() {
            PmApplicationController.this.enter("BaseJob.allSessionsAreDoneReportingInstantCounters");
            PmApplicationController.this.error("Unexpected call to allSessionsAreDoneReportingInstantCounters");
            return false;
        }

        public int getTimeoutInMs() {
            PmApplicationController.this.enter("BaseJob.getTimeoutInMs");
            return this.m_defaultTimeout;
        }

        public void onTimeout() {
            PmApplicationController.this.enter("BaseJob.onTimeout");
            String description = this.description();
            PmApplicationController.this.error("Job: " + description + " timed out");
            PmApplicationController.this.m_callback.applicationController_resetNonRespondingSessions();
        }
    }

    public static interface Job {
        public String description();

        public int init();

        public boolean allSessionsAreDoneUpdatingActive();

        public boolean allSessionsAreDoneFreezing();

        public boolean reportCounterValues(MeasuredData[] var1, boolean var2);

        public boolean reportInstantCounterValues(PmMeasuredInstantData var1);

        public boolean allSessionsAreDoneReporting();

        public boolean allSessionsAreDoneReportingInstantCounters();

        public int getTimeoutInMs();

        public void onTimeout();
    }

    public static interface Callback {
        public boolean applicationController_mopplet_startThread(Runnable var1, String var2);

        public boolean applicationController_listenToSignals();

        public boolean applicationController_activateCounters(PmClassCounter[] var1);

        public boolean applicationController_deactivateCounters(PmClassCounter[] var1);

        public boolean applicationController_enableCounters(PmClassCounter[] var1);

        public boolean applicationController_freezeCountersEvent();

        public boolean applicationController_reportCountersEvent();

        public boolean applicationController_reportInstantCountersEvent(String var1, String var2, String[] var3);

        public boolean applicationController_startJobTimer(int var1);

        public boolean applicationController_cancelJobTimer();

        public boolean applicationController_resetNonRespondingSessions();

        public boolean applicationController_startCounterRegistrationDeadlineTimer(int var1);
    }
}

