/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common;

import java.io.BufferedInputStream;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;

public class ExternalCommandHelper {
    private static final Class THIS_CLASS = ExternalCommandHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private ExternalCommandHelper() {
    }

    public static CommandOutput runCommand(String string) {
        logger.traceEnter(THIS_CLASS, "runCommand(" + string + ")");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            Process process = Runtime.getRuntime().exec(string);
            process.waitFor();
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            int n = bufferedInputStream.read(byArray);
            while (n > 0) {
                stringBuffer.append(new String(byArray, 0, n));
                n = bufferedInputStream.read(byArray);
            }
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(process.getErrorStream());
            int n2 = bufferedInputStream2.read(byArray);
            while (n2 > 0) {
                stringBuffer2.append(new String(byArray, 0, n2));
                n2 = bufferedInputStream2.read(byArray);
            }
        }
        catch (Exception exception) {
            stringBuffer2.append(ExceptionHelper.convertToString((Throwable)exception));
        }
        logger.traceReturn(THIS_CLASS, "runCommand(" + string + ")");
        return new CommandOutput(string, stringBuffer, stringBuffer2);
    }

    public static class CommandOutput {
        public final String command;
        public final String stdOut;
        public final String stdErr;

        public CommandOutput(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            this.command = string;
            this.stdOut = stringBuffer.toString();
            this.stdErr = stringBuffer2.toString();
        }
    }
}

