/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import se.ericsson.crbs.common.StringHelper;

public class FileHelper
extends se.ericsson.crbs.common.FileHelper {
    public static final String AVOID_PMD = "";

    private FileHelper() {
    }

    public static String getFileContents(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer((int)(file.length() + 10L));
        n = fileInputStream.read(byArray);
        while (n > 0) {
            stringBuffer.append(new String(byArray, 0, n));
            n = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        return stringBuffer.toString();
    }

    public static String getInitialFileContents(File file, long l) throws IOException {
        long l2 = Math.min(l, file.length());
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 1024;
        if (l2 < (long)n) {
            n = (int)l2;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        long l3 = 0L;
        n2 = fileInputStream.read(byArray);
        while (n2 > 0) {
            if (l3 + (long)n2 > l2) {
                int n3 = (int)(l2 - l3);
                stringBuffer.append(new String(byArray, 0, n3));
                l3 += (long)n3;
            } else {
                stringBuffer.append(new String(byArray, 0, n2));
                l3 += (long)n2;
            }
            if (l3 >= l2) break;
            n2 = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        return stringBuffer.toString();
    }

    public static void copyFile(File file, File file2) throws IOException {
        byte[] byArray = new byte[4096];
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        int n = fileInputStream.read(byArray);
        while (n > 0) {
            fileOutputStream.write(byArray, 0, n);
            n = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void deleteFilesInDirectory(File file) throws FileException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new FileException("Deletion must start from a directory.");
            }
            List<File> list = Arrays.asList(file.listFiles());
            for (int i = 0; i < list.size(); ++i) {
                File file2 = list.get(i);
                if (!file2.isFile() || file2.delete()) continue;
                throw new FileException("Could not delete file: " + StringHelper.doubleQuote((String)file2.getPath()));
            }
        }
    }

    public static void deleteFilesInDirectory(String string, File file) throws FileException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new FileException("Deletion must start from a directory.");
            }
            List<File> list = Arrays.asList(file.listFiles());
            for (int i = 0; i < list.size(); ++i) {
                File file2 = list.get(i);
                if (!file2.isFile() || !file2.getName().toLowerCase(Locale.getDefault()).endsWith(string.toLowerCase(Locale.getDefault())) || file2.delete()) continue;
                throw new FileException("Could not delete file: " + StringHelper.doubleQuote((String)file2.getPath()));
            }
        }
    }

    public static class FileException
    extends Exception {
        public FileException(String string) {
            super(string);
        }

        public FileException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

