/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.attributehandling;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.commonmo.transactions.transactionlistener.TransactionTypeList;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.lte.rbs.omf.common.DateTimeHelper;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;

public class AttributeUtilities {
    public static final String CREATED_BY = "createdBy";
    public static final Integer CREATED_BY_IRAT_OPERATOR = new Integer(0);
    public static final Integer CREATED_BY_IRAT_ANR = new Integer(1);
    public static final Integer CREATED_BY_EUTRAN_X2 = new Integer(1);
    public static final Integer CREATED_BY_EUTRAN_OPERATOR = new Integer(2);
    public static final String TIME_OF_CREATION = "timeOfCreation";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String LAST_MODIFICATION = "lastModification";
    public static final Integer LAST_MODIFICATION_EUTRAN_OPERATOR_MODIFICATION = new Integer(2);
    public static final Integer LAST_MODIFICATION_EUTRAN_OPERATOR_DELETE = new Integer(5);
    public static final Integer LAST_MODIFICATION_EUTRAN_NOT_MODIFIED = new Integer(6);
    public static final Integer LAST_MODIFICATION_GERAN_OPERATOR_MODIFICATION = new Integer(1);
    public static final Integer LAST_MODIFICATION_GERAN_NOT_MODIFIED = new Integer(2);
    public static final Integer LAST_MODIFICATION_UTRAN_OPERATOR_MODIFICATION = new Integer(1);
    public static final Integer LAST_MODIFICATION_UTRAN_NOT_MODIFIED = new Integer(2);
    public static final Integer LAST_MODIFICATION_SOURCE_CELL_OPERATOR = new Integer(0);
    public static final String TIME_OF_LAST_MODIFICATION = "timeOfLastModification";
    private static final Class THIS_CLASS = AttributeUtilities.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final Object lock = new Object();
    public static final String ADDITIONALFREQBANDLIST = "additionalFreqBandList";
    public static final String FREQ_BAND = "freqBand";

    public static void validateAttributeShouldBeSame(MoIterator moIterator, ManagedObject managedObject, Object[] objectArray, String string, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        AttributeUtilities.validateAttribute(moIterator, managedObject, objectArray, new String[]{string}, true, coordinator);
    }

    public static void validateSeveralAttributeCombinationShouldBeUnique(MoIterator moIterator, ManagedObject managedObject, Object[] objectArray, String[] stringArray, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        AttributeUtilities.validateAttribute(moIterator, managedObject, objectArray, stringArray, false, coordinator);
    }

    public static void validateAttributeShouldBeUnique(MoIterator moIterator, ManagedObject managedObject, Object[] objectArray, String string, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        AttributeUtilities.validateAttribute(moIterator, managedObject, objectArray, new String[]{string}, false, coordinator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateAttribute(MoIterator moIterator, ManagedObject managedObject, Object[] objectArray, String[] stringArray, boolean bl, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        if (moIterator != null) {
            logger.traceEnter(THIS_CLASS, "validateAttribute(moIterator.size = " + moIterator.size() + ", " + "mo = " + managedObject.getLocalDistinguishedName() + ", attributeNames.length " + stringArray.length + ", shouldBeSame = " + bl + ")");
            Object object = lock;
            synchronized (object) {
                String string = bl ? "validateAttributeShouldBeSame" : "validateAttributeShouldBeUnique";
                logger.traceEnter(THIS_CLASS, "validateAttribute(siblings, moLdn=" + managedObject.getLocalDistinguishedName() + "), called from: " + string);
                while (moIterator != null && moIterator.hasMoreElements()) {
                    ManagedObject managedObject2 = (ManagedObject)moIterator.nextElement();
                    String string2 = managedObject2.getLocalDistinguishedName();
                    if (MoCheck.isMoNotReadable(managedObject2) || string2.equals(managedObject.getLocalDistinguishedName())) continue;
                    AttributeUtilities.validateSiblingParameters(stringArray, managedObject, objectArray, managedObject2, bl, coordinator);
                }
                logger.traceReturn(THIS_CLASS, "validateAttribute()");
            }
        }
    }

    private static void validateSiblingParameters(String[] stringArray, ManagedObject managedObject, Object[] objectArray, ManagedObject managedObject2, boolean bl, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateSiblingParameters()");
        if (stringArray.length == 1) {
            AttributeUtilities.validateOutcomeOfSingleParam(stringArray, bl, managedObject, objectArray, managedObject2, coordinator);
        } else {
            AttributeUtilities.validatedOutcomeOfSeveralParameters(stringArray, bl, managedObject, objectArray, managedObject2, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "validateSiblingParameters()");
    }

    private static boolean validateOutcomeOfSingleParam(String[] stringArray, boolean bl, ManagedObject managedObject, Object[] objectArray, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateOutcomeOfSingleParam()");
        String string = stringArray[0];
        Object object = objectArray[0];
        Object object2 = managedObject2.getAttribute(string, coordinator);
        boolean bl2 = AttributeUtilities.compareValue(bl, object, object2);
        if (!bl2) {
            if (bl) {
                String string2 = "The values for attribute [" + string + "] must be the same for all MOs of the type [" + managedObject.getType() + "]. The value [" + AttributeUtilities.valueToString(object) + "] for MO [" + managedObject.getLocalDistinguishedName() + "] does not match the value [" + AttributeUtilities.valueToString(object2) + "] for MO [" + managedObject2.getLocalDistinguishedName() + "]";
                AttributeUtilities.logInfoAndThrowException(string2);
            } else {
                String string3 = "The values for attribute [" + string + "] must be unique among all MOs." + "The value [" + AttributeUtilities.valueToString(object) + "] for MO [" + managedObject.getLocalDistinguishedName() + "] is the same as for MO [" + managedObject2.getLocalDistinguishedName() + "]";
                AttributeUtilities.logInfoAndThrowException(string3);
            }
        }
        logger.traceReturn(THIS_CLASS, "validateOutcomeOfSingleParam(return " + bl2 + ")");
        return bl2;
    }

    protected static boolean compareValue(boolean bl, Object object, Object object2) {
        logger.traceEnter(THIS_CLASS, "compareValue(shouldBeSame[" + bl + "], referenceValue[" + object + "], siblingValue[" + object2 + "])");
        boolean bl2 = true;
        bl2 = object instanceof Object[] && object2 instanceof Object[] ? AttributeUtilities.compareStructValues(bl, object, object2) : (object instanceof Struct && object2 instanceof Struct ? AttributeUtilities.compareStructs(bl, object, object2) : AttributeUtilities.compareNonStruct(bl, object, object2));
        logger.traceReturn(THIS_CLASS, "compareValue(Result[" + bl2 + "])");
        return bl2;
    }

    private static boolean compareStructValues(boolean bl, Object object, Object object2) {
        boolean bl2;
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        boolean bl3 = true;
        boolean bl4 = bl2 = objectArray.length == objectArray2.length;
        if (bl2) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (AttributeUtilities.compareValue(bl, objectArray[i], objectArray2[i])) continue;
                bl3 = false;
                break;
            }
        } else if (bl) {
            bl3 = false;
        }
        return bl3;
    }

    private static boolean compareStructs(boolean bl, Object object, Object object2) {
        logger.traceEnter(THIS_CLASS, "compareStructs()");
        boolean bl2 = true;
        boolean bl3 = StructImpl.compareStructs((Struct)((Struct)object), (Struct)((Struct)object2));
        if (bl && !bl3 || !bl && bl3) {
            bl2 = false;
        }
        logger.traceReturn(THIS_CLASS, "compareStructs()");
        return bl2;
    }

    private static boolean compareNonStruct(boolean bl, Object object, Object object2) {
        logger.traceEnter(THIS_CLASS, "comparenonStructs()");
        boolean bl2 = true;
        if (bl) {
            if (object2 == null || !object.equals(object2)) {
                bl2 = false;
            }
        } else if (object != null && object.equals(object2)) {
            bl2 = false;
        }
        logger.traceReturn(THIS_CLASS, "compareNonStructs()");
        return bl2;
    }

    private static void validatedOutcomeOfSeveralParameters(String[] stringArray, boolean bl, ManagedObject managedObject, Object[] objectArray, ManagedObject managedObject2, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        Object object;
        logger.traceEnter(THIS_CLASS, "validatedOutcomeOfSeveralParameters()");
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Object[] objectArray2 = managedObject2.getAttributes(stringArray, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            object = objectArray[i];
            Object object2 = objectArray2[i];
            if (!AttributeUtilities.compareValue(bl, object, object2)) {
                ++n;
            }
            stringBuffer.append("[" + stringArray[i] + " = " + AttributeUtilities.valueToString(object) + "] ");
            stringBuffer2.append("[" + stringArray[i] + " = " + AttributeUtilities.valueToString(object2) + "] ");
        }
        if (bl) {
            if (n > 0) {
                object = "The combination of attributes [" + stringBuffer + "] for MO [" + managedObject.getLocalDistinguishedName() + "] should be the same as for the other MOs of same type. Values [" + stringBuffer2 + "]";
                AttributeUtilities.logInfoAndThrowException((String)object);
            }
        } else if (n == stringArray.length) {
            object = "The combination of attributes [" + stringBuffer + "] for MO [" + managedObject.getLocalDistinguishedName() + "] is not unique, they are already used by another MO [" + managedObject2.getLocalDistinguishedName() + "]";
            AttributeUtilities.logInfoAndThrowException((String)object);
        }
        logger.traceReturn(THIS_CLASS, "validatedOutcomeOfSeveralParameters(return true)");
    }

    public static Pair isAttributeSameAsSiblings(MoIterator moIterator, String string, Object object, String string2, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceReturn(THIS_CLASS, "isAttributeSameAsSiblings()");
        return AttributeUtilities.validateAttribut(false, moIterator, string, object, string2, coordinator);
    }

    public static Pair isAttributUnique(MoIterator moIterator, String string, Object object, String string2, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceReturn(THIS_CLASS, "isAttributUnique()");
        return AttributeUtilities.validateAttribut(true, moIterator, string, object, string2, coordinator);
    }

    private static Pair validateAttribut(boolean bl, MoIterator moIterator, String string, Object object, String string2, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateAttribute(shouldBeUnique=" + bl + ")");
        Pair pair = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            Object object2;
            ManagedObject managedObject = (ManagedObject)moIterator.nextElement();
            String string3 = managedObject.getLocalDistinguishedName();
            if (MoCheck.isMoNotReadable(managedObject) || string3.equals(string) || (pair = AttributeUtilities.compareShouldBeUnique(bl, object, object2 = managedObject.getAttribute(string2, coordinator), string3)) == null) continue;
            break;
        }
        logger.traceReturn(THIS_CLASS, "validateAttribute()");
        return pair;
    }

    private static Pair compareShouldBeUnique(boolean bl, Object object, Object object2, String string) {
        logger.traceEnter(THIS_CLASS, "compareShouldBeUnique()");
        Pair pair = null;
        if (bl) {
            boolean bl2 = false;
            bl2 = object instanceof Struct ? StructImpl.compareStructs((Struct)((Struct)object), (Struct)((Struct)object2)) : object.equals(object2);
            if (bl2) {
                pair = new Pair(string, object2);
            }
        } else {
            boolean bl3 = true;
            bl3 = object instanceof Struct ? StructImpl.compareStructs((Struct)((Struct)object), (Struct)((Struct)object2)) : object.equals(object2);
            if (!bl3) {
                pair = new Pair(string, object2);
            }
        }
        logger.traceReturn(THIS_CLASS, "compareShouldBeUnique():");
        return pair;
    }

    public static Pair validateAttributeUniqueCombination(String string, MoIterator moIterator, String[] stringArray, Object[] objectArray, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "isAttrUnique()");
        if (stringArray.length != objectArray.length) {
            logger.traceError(THIS_CLASS, "Invalid Parameter: attributeNames and attributeValues must have identical size.");
            return null;
        }
        Pair pair = null;
        while (moIterator.hasMoreElements()) {
            int n;
            ManagedObject managedObject = (ManagedObject)moIterator.nextElement();
            if (MoCheck.isMoNotReadable(managedObject) || string.equals(managedObject.getLocalDistinguishedName()) || (n = AttributeUtilities.getNumberOfMatches(stringArray, managedObject, objectArray, coordinator)) != stringArray.length) continue;
            pair = new Pair(managedObject.getLocalDistinguishedName(), null);
            break;
        }
        logger.traceEnter(THIS_CLASS, "isAttrUnique()");
        return pair;
    }

    private static int getNumberOfMatches(String[] stringArray, ManagedObject managedObject, Object[] objectArray, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getNumberOfMatches()");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = managedObject.getAttribute(stringArray[i], coordinator);
            if (objectArray[i] instanceof Struct && object instanceof Struct) {
                if (!StructImpl.compareStructs((Struct)((Struct)objectArray[i]), (Struct)((Struct)object))) continue;
                ++n;
                continue;
            }
            if (!objectArray[i].equals(object)) continue;
            ++n;
        }
        logger.traceReturn(THIS_CLASS, "getNumberOfMatches()");
        return n;
    }

    public static void setInitialTimeParameters(GenericMao genericMao, Integer n, Integer n2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setInitialTimeParameters()");
        genericMao.setReadOnlyAttribute(TIME_OF_CREATION, (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), YYYY_MM_DD_HH_MM_SS), coordinator);
        genericMao.setReadOnlyAttribute(CREATED_BY, (Object)n, coordinator);
        if (n2 >= 0) {
            genericMao.setReadOnlyAttribute(LAST_MODIFICATION, (Object)n2, coordinator);
            genericMao.setReadOnlyAttribute(TIME_OF_LAST_MODIFICATION, (Object)"", coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setInitialTimeParameters()");
    }

    public static void setModificationAttribute(String string, GenericMao genericMao, Integer n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setModificationAttribute()");
        boolean bl = false;
        if (!(string.equals(TIME_OF_LAST_MODIFICATION) || string.equals(LAST_MODIFICATION) || string.equals(TIME_OF_CREATION) || string.equals(CREATED_BY))) {
            bl = true;
        }
        if (bl) {
            genericMao.setReadOnlyAttribute(TIME_OF_LAST_MODIFICATION, (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), YYYY_MM_DD_HH_MM_SS), coordinator);
            if (!TransactionTypeList.getInstance().isNonBlocking(coordinator)) {
                genericMao.setReadOnlyAttribute(LAST_MODIFICATION, (Object)n, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "setModificationAttribute()");
    }

    public static void setModificationAttrAtDelete(GenericMao genericMao, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setModificationAttrAtDelete()");
        if (!TransactionTypeList.getInstance().isNonBlocking(coordinator)) {
            genericMao.setReadOnlyAttribute(LAST_MODIFICATION, (Object)LAST_MODIFICATION_EUTRAN_OPERATOR_DELETE, coordinator);
        }
        genericMao.setReadOnlyAttribute(TIME_OF_LAST_MODIFICATION, (Object)DateTimeHelper.dateToString(System.currentTimeMillis(), YYYY_MM_DD_HH_MM_SS), coordinator);
        logger.traceReturn(THIS_CLASS, "setModificationAttrAtDelete()");
    }

    public static String valueToString(Object object) throws NotHandledAttributeTypeException, MoNotFoundException, NoSuchFieldException {
        String string = "";
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                string = string + AttributeUtilities.valueToString(objectArray[i]);
                string = string + " ";
            }
        } else if (object instanceof Struct) {
            Struct struct = (Struct)object;
            String[] stringArray = struct.getNames();
            String string2 = "[";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    string2 = string2 + ":";
                }
                string2 = string2 + stringArray[i] + "=" + struct.getValue(stringArray[i]);
            }
            string = string2 = string2 + "]";
        } else {
            string = object.toString();
        }
        return string;
    }

    private static void logInfoAndThrowException(String string) throws PrepareFailedException {
        logger.info(THIS_CLASS, string);
        throw new PrepareFailedException(string);
    }
}

