/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.proxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeException;
import se.ericsson.cello.neal.NodeFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.ExceptionHelper;
import se.ericsson.lte.rbs.omf.common.proxy.IllegalSignal;
import se.ericsson.lte.rbs.omf.common.proxy.OseSenderReceiver;
import se.ericsson.lte.rbs.omf.common.proxy.OseSenderReceiverFactory;
import se.ericsson.lte.rbs.omf.common.proxy.SignalConverter;
import se.ericsson.lte.rbs.omf.common.proxy.SignalException;
import se.ericsson.lte.rbs.omf.common.proxy.SignalHandler;
import se.ericsson.lte.rbs.omf.common.proxy.SignalObject;

public abstract class AbstractSignalConverter
implements SignalConverter,
Runnable {
    private static final Class THIS_CLASS = AbstractSignalConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected final List signalHandlers = new ArrayList();
    private final String serviceName;
    private final OseSenderReceiver oseSenderReceiver;
    private boolean serviceRunning = false;
    protected OseProcess inputThreadProcess = null;
    private QueueThread queueThread = null;
    private final SignalRegistry sigReg;
    private Thread inputThread = null;
    protected final List signalsToBeSent = new ArrayList();

    public AbstractSignalConverter(String string, Class[] classArray) {
        this.serviceName = string;
        this.oseSenderReceiver = OseSenderReceiverFactory.getInstance().getOseSenderReceiver();
        this.sigReg = new SignalRegistry();
        for (int i = 0; i < classArray.length; ++i) {
            this.sigReg.add(classArray[i]);
        }
    }

    public abstract void inputSignalReceived(InSignal var1) throws IllegalSignal;

    public void sendSignal(OseProcess oseProcess, OseProcess oseProcess2, Signal signal) throws SignalException {
        this.oseSenderReceiver.sendSignal(oseProcess, oseProcess2, signal);
    }

    public void run() {
        logger.traceEnter(THIS_CLASS, "AbstractSignalConverter.run");
        this.waitForServiceToComeUp();
        this.inputThreadProcess = this.oseSenderReceiver.getThisProcess();
        this.oseSenderReceiver.addServiceToOseNameServer(this.serviceName);
        while (this.serviceRunning) {
            try {
                InSignal inSignal = this.oseSenderReceiver.receiveSignal(this.sigReg, 5000);
                if (inSignal == null) continue;
                logger.traceDebug(THIS_CLASS, "AbstractSignalConverter.run got signal");
                this.queueThread.addInputSignal(inSignal);
            }
            catch (Exception exception) {
                logger.traceError(THIS_CLASS, "Received exception when reading OSE signal: " + ExceptionHelper.getExceptionMessage((Throwable)exception));
            }
        }
        logger.traceDebug(THIS_CLASS, "Service is not running");
        this.oseSenderReceiver.removeServiceFromOseNameServer(this.serviceName);
        logger.traceReturn(THIS_CLASS, "AbstractSignalConverter.run");
    }

    protected void waitForServiceToComeUp() {
        logger.traceEnter(THIS_CLASS, "waitForServiceToComeUp()");
        while (this.serviceRunning) {
            try {
                Node node = NodeFactory.getNode();
                node.getCmService();
                break;
            }
            catch (NodeException nodeException) {
                logger.traceDebug(THIS_CLASS, "MO service not up, waiting...");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        logger.traceReturn(THIS_CLASS, "waitForServiceToComeUp()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSignalHandler(SignalObject signalObject, SignalHandler signalHandler) {
        List list = this.signalHandlers;
        synchronized (list) {
            SignalHandlerHolder signalHandlerHolder = new SignalHandlerHolder(signalObject, signalHandler);
            if (!this.signalHandlers.contains(signalHandlerHolder)) {
                this.signalHandlers.add(signalHandlerHolder);
                logger.traceGeneral(THIS_CLASS, "Added: " + signalHandlerHolder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSignalHandler(SignalObject signalObject, SignalHandler signalHandler) {
        List list = this.signalHandlers;
        synchronized (list) {
            SignalHandlerHolder signalHandlerHolder = new SignalHandlerHolder(signalObject, signalHandler);
            if (this.signalHandlers.remove(signalHandlerHolder)) {
                logger.traceGeneral(THIS_CLASS, "Removed: " + signalHandlerHolder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalHandler[] getSignalHandlers(SignalObject signalObject) {
        List list = this.signalHandlers;
        synchronized (list) {
            ArrayList<SignalHandler> arrayList = new ArrayList<SignalHandler>();
            if (signalObject != null) {
                for (int i = 0; i < this.signalHandlers.size(); ++i) {
                    SignalHandlerHolder signalHandlerHolder = (SignalHandlerHolder)this.signalHandlers.get(i);
                    if (!((Object)signalHandlerHolder.signalObject).equals(signalObject)) continue;
                    arrayList.add(signalHandlerHolder.signalHandler);
                }
            }
            SignalHandler[] signalHandlerArray = new SignalHandler[arrayList.size()];
            arrayList.toArray(signalHandlerArray);
            return signalHandlerArray;
        }
    }

    public void startService() {
        logger.traceEnter(THIS_CLASS, "startService()");
        this.inputThread = new Thread((Runnable)this, "Input Thread for Proxy: \"" + this.serviceName + "\"");
        this.queueThread = new QueueThread(this.serviceName);
        this.serviceRunning = true;
        this.queueThread.startQueue();
        this.inputThread.start();
        logger.traceReturn(THIS_CLASS, "startService()");
    }

    public void stopService() {
        logger.traceEnter(THIS_CLASS, "stopService()");
        this.stopService(0);
        logger.traceReturn(THIS_CLASS, "stopService()");
    }

    public void stopService(int n) {
        logger.traceEnter(THIS_CLASS, "stopService(" + n + ")");
        this.serviceRunning = false;
        this.queueThread.stopQueue();
        if (n > 0) {
            long l = System.currentTimeMillis() + (long)n;
            while (System.currentTimeMillis() < l && this.queueThread.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        logger.traceReturn(THIS_CLASS, "stopService(" + n + ")");
    }

    public boolean isServiceRunning() {
        return this.serviceRunning && this.inputThread.isAlive() && this.queueThread != null && this.queueThread.isAlive();
    }

    protected OseProcess getSender(InSignal inSignal) {
        return this.oseSenderReceiver.getSender(inSignal);
    }

    protected InSignal peekSignalQueue() {
        InSignal inSignal = null;
        int n = this.signalsToBeSent.size();
        if (n > 0) {
            inSignal = (InSignal)this.signalsToBeSent.get(0);
        }
        return inSignal;
    }

    private class QueueThread
    extends Thread {
        private boolean queueRunning;
        private final List waitingSignals;

        public QueueThread(String string) {
            super("Queueing Thread for Proxy: \"" + string + "\"");
            this.queueRunning = false;
            this.waitingSignals = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.queueRunning) {
                try {
                    AbstractSignalConverter.this.signalsToBeSent.clear();
                    List list = this.waitingSignals;
                    synchronized (list) {
                        AbstractSignalConverter.this.signalsToBeSent.addAll(this.waitingSignals);
                        this.waitingSignals.clear();
                    }
                    while (!AbstractSignalConverter.this.signalsToBeSent.isEmpty()) {
                        list = (InSignal)AbstractSignalConverter.this.signalsToBeSent.remove(0);
                        String string = list.getClass().getName();
                        logger.traceGeneral(THIS_CLASS, "Executing queued signal: [" + string + "]");
                        AbstractSignalConverter.this.inputSignalReceived((InSignal)list);
                    }
                    list = this.waitingSignals;
                    synchronized (list) {
                        if (this.waitingSignals.isEmpty()) {
                            this.waitingSignals.wait(5000L);
                        }
                    }
                }
                catch (IllegalSignal illegalSignal) {
                    logger.traceError(THIS_CLASS, "Received IllegalSignal while execution queue of request: " + illegalSignal.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    logger.traceError(THIS_CLASS, "Received InterruptedException while execution of queue request: " + interruptedException.getMessage());
                }
                catch (Exception exception) {
                    logger.traceError(THIS_CLASS, "Received exception while execution of queue request:" + exception.getClass() + " " + ExceptionHelper.getExceptionMessage((Throwable)exception));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addInputSignal(InSignal inSignal) {
            List list = this.waitingSignals;
            synchronized (list) {
                String string = inSignal.getClass().getName();
                logger.traceGeneral(THIS_CLASS, "Received new input signal: [" + string + "]");
                this.waitingSignals.add(inSignal);
                this.waitingSignals.notifyAll();
            }
        }

        public void startQueue() {
            this.queueRunning = true;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopQueue() {
            this.queueRunning = false;
            List list = this.waitingSignals;
            synchronized (list) {
                this.waitingSignals.notifyAll();
            }
        }
    }

    private class SignalHandlerHolder {
        private final SignalObject signalObject;
        private final SignalHandler signalHandler;
        private final int hashValue;
        private final String stringValue;

        SignalHandlerHolder(SignalObject signalObject, SignalHandler signalHandler) {
            this.signalObject = signalObject;
            this.signalHandler = signalHandler;
            this.hashValue = (((Object)this.signalHandler).toString() + ((Object)this.signalObject).toString()).hashCode();
            this.stringValue = "Signal handler \"" + this.signalHandler + "\" for signal object, \"" + this.signalObject + "\"";
        }

        protected SignalObject getSignalObject() {
            return this.signalObject;
        }

        protected SignalHandler getSignalHandler() {
            return this.signalHandler;
        }

        public final int hashCode() {
            return this.hashValue;
        }

        public final boolean equals(Object object) {
            boolean bl = false;
            if (object != null && object instanceof SignalHandlerHolder) {
                SignalHandlerHolder signalHandlerHolder = (SignalHandlerHolder)object;
                bl = this.signalObject.getSignalNumber() == signalHandlerHolder.getSignalObject().getSignalNumber() && this.signalHandler.equals(signalHandlerHolder.getSignalHandler());
            }
            return bl;
        }

        public final String toString() {
            return this.stringValue;
        }
    }
}

