/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.lte.rbs.omf.common.attributehandling.Pair;
import se.ericsson.lte.rbs.omf.common.exception.NotFoundException;
import se.ericsson.lte.rbs.omf.common.exception.PreCreateValidationException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class AbstractGenericAttributeValidatorMao
extends GenericMao {
    private static final Class THIS_CLASS = AbstractGenericAttributeValidatorMao.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private Map attrValidatorMap;
    private Coordinator lastTransactionUsed;
    private Coordinator createdInCurrentTransaction;
    private List replacingAttrAtCreateList;

    public AbstractGenericAttributeValidatorMao(ManagedObject managedObject, AttrList attrList, String string, String string2, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, string2, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "GenericAttributeValidatorMao()");
        logger.traceReturn(THIS_CLASS, "GenericAttributeValidatorMao()");
    }

    public AbstractGenericAttributeValidatorMao(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "GenericAttributeValidatorMao(recover)");
        logger.traceReturn(THIS_CLASS, "GenericAttributeValidatorMao(recover)");
    }

    public Map getValidatorMap() {
        logger.traceEnter(THIS_CLASS, "getValidatorMap()");
        if (this.attrValidatorMap == null) {
            this.attrValidatorMap = new HashMap();
            this.registerValidators();
        }
        logger.traceReturn(THIS_CLASS, "getValidatorMap()");
        return (Map)((HashMap)this.attrValidatorMap).clone();
    }

    protected void registerValidators() {
    }

    protected final void registerValidator(String string, AbstractAttributeValidator abstractAttributeValidator) {
        logger.traceEnter(THIS_CLASS, "registerValidator(attributeName[" + string + "])");
        List<AbstractAttributeValidator> list = null;
        if (this.attrValidatorMap.containsKey(string)) {
            list = (List)this.attrValidatorMap.get(string);
        } else {
            list = new ArrayList();
            this.attrValidatorMap.put(string, list);
        }
        list.add(abstractAttributeValidator);
        logger.traceReturn(THIS_CLASS, "registerValidator()");
    }

    public void preCreateValidation(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preCreateValidation(AttrList, Coordinator)");
        this.createdInCurrentTransaction = coordinator;
        this.registerAndStoreCoordinator(coordinator, true);
        Map map = this.getValidatorMap();
        for (int i = 0; i < attrList.size(); ++i) {
            String string = attrList.getName(i);
            Object object = attrList.getValue(i);
            if (!map.containsKey(string)) continue;
            List list = (List)map.get(string);
            try {
                this.validateAtCreate(object, attrList, list, coordinator);
                continue;
            }
            catch (PrepareFailedException prepareFailedException) {
                throw new PreCreateValidationException(this.getMoType(), prepareFailedException.reason);
            }
        }
        logger.traceReturn(THIS_CLASS, "preCreateValidation(AttrList, Coordinator)");
    }

    private void validateAtCreate(Object object, AttrList attrList, List list, Coordinator coordinator) throws PrepareFailedException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractAttributeValidator abstractAttributeValidator = (AbstractAttributeValidator)iterator.next();
            abstractAttributeValidator.validateAtCreate((ManagedObject)this, object, attrList, coordinator);
        }
    }

    public boolean isCreatedInCurrentTransaction(Coordinator coordinator) {
        boolean bl = false;
        if (this.createdInCurrentTransaction != null) {
            bl = this.createdInCurrentTransaction.getTransactionID() == coordinator.getTransactionID();
        }
        return bl;
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet, attribute: " + string + "=" + object);
        Map map = this.getValidatorMap();
        if (map.containsKey(string)) {
            this.registerAndStoreCoordinator(coordinator, true);
            List list = (List)map.get(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AbstractAttributeValidator abstractAttributeValidator = (AbstractAttributeValidator)iterator.next();
                abstractAttributeValidator.handlePostSet((ManagedObject)this, string, object);
            }
        }
        this.registerAndStoreCoordinator(coordinator, false);
        logger.traceReturn(THIS_CLASS, "postSet");
    }

    public void preDelete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        if (coordinator != null) {
            this.lastTransactionUsed = coordinator;
        }
    }

    public void prepare(Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "prepare()");
        Map map = this.getValidatorMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            List list = (List)map.get(k);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                AbstractAttributeValidator abstractAttributeValidator = (AbstractAttributeValidator)iterator2.next();
                if (this.isRemoved()) {
                    abstractAttributeValidator.validateAtDelete((ManagedObject)this, coordinator);
                    continue;
                }
                abstractAttributeValidator.validateAtPrepare((ManagedObject)this, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "prepare()");
    }

    protected final void registerAndStoreCoordinator(Coordinator coordinator, boolean bl) {
        if (coordinator != null) {
            if (this.lastTransactionUsed == null || this.lastTransactionUsed.getTransactionID() != coordinator.getTransactionID()) {
                this.lastTransactionUsed = coordinator;
            }
            try {
                if (bl) {
                    this.registerGenericMaoInTransaction(coordinator);
                }
            }
            catch (MoAccessException moAccessException) {
                logger.traceError(THIS_CLASS, "Could not register in the coordinator, got exception: " + (Object)((Object)moAccessException));
            }
        }
    }

    protected Map getDeprecatedAttributesMap() throws MoAccessException {
        return Collections.EMPTY_MAP;
    }

    public final AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addFroParametersAtCreate()");
        this.handleDeprecatedAtCreateFromMap(attrList);
        this.createDeprecatedWithSpecialHandling((AttrListImpl)attrList, (AttrListImpl)attrList2);
        this.performSpecialHandlingAtCreate((AttrListImpl)attrList, (AttrListImpl)attrList2, coordinator);
        logger.traceReturn(THIS_CLASS, "addFroParametersAtCreate()");
        return super.addFroParametersAtCreate(attrList, attrList2, coordinator);
    }

    protected void performSpecialHandlingAtCreate(AttrListImpl attrListImpl, AttrListImpl attrListImpl2, Coordinator coordinator) throws MoAccessException {
    }

    protected void createDeprecatedWithSpecialHandling(AttrListImpl attrListImpl, AttrListImpl attrListImpl2) {
    }

    private void handleDeprecatedAtCreateFromMap(AttrList attrList) throws MoAccessException {
        Map map = this.getDeprecatedAttributesMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = attrList.indexOf(string);
            if (n == -1) continue;
            Object object = attrList.getValue(n);
            attrList.removeElementAt(n);
            Pair pair = (Pair)map.get(string);
            this.storeReplacementInfoAtCreate(pair.name, (String)pair.value, object);
        }
    }

    private List getReplacingAttrAtCreateList() {
        if (this.replacingAttrAtCreateList == null) {
            this.replacingAttrAtCreateList = new ArrayList();
        }
        return this.replacingAttrAtCreateList;
    }

    protected final void storeReplacementInfoAtCreate(String string, String string2, Object object) {
        this.getReplacingAttrAtCreateList().add(new ReplacementInfo(string, string2, object));
    }

    public void postCreate(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        Iterator iterator = this.getReplacingAttrAtCreateList().iterator();
        while (iterator.hasNext()) {
            ReplacementInfo replacementInfo = (ReplacementInfo)iterator.next();
            String string = replacementInfo.ldn;
            ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(string);
            if (managedObject == null) {
                String string2 = "MO " + string + " with replacing attribute " + replacementInfo.attributeName + " not found.";
                throw new NotFoundException("EUtranCellFDD/EUtranCellTDD", string2);
            }
            managedObject.setAttribute(replacementInfo.attributeName, replacementInfo.attributeValue, coordinator);
        }
        this.getReplacingAttrAtCreateList().clear();
        super.postCreate(attrList, coordinator);
    }

    protected final Object removeAttributeAndGetValueDuringCreate(AttrList attrList, String string) {
        int n = attrList.indexOf(string);
        Object object = null;
        if (n != -1) {
            try {
                object = attrList.getValue(n);
            }
            catch (MoAccessException moAccessException) {
                // empty catch block
            }
            attrList.removeElementAt(n);
        }
        return object;
    }

    public final void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair;
        logger.traceEnter(THIS_CLASS, "setAttribute(attributeName[" + string + "], attributeValue[" + object + "])");
        Pair pair2 = this.performSpecialHandllingAtSet(string, object, coordinator);
        if (pair2 != null && (pair = this.handleDeprecatedAtSet(pair2.name, pair2.value, coordinator)) != null) {
            super.setAttribute(pair.name, pair.value, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    public final void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes(no of attributes = " + stringArray.length + ")");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            Pair pair;
            Pair pair2 = this.performSpecialHandllingAtSet(stringArray[i], objectArray[i], coordinator);
            if (pair2 == null || (pair = this.handleDeprecatedAtSet(pair2.name, pair2.value, coordinator)) == null) continue;
            arrayList.add(pair.name);
            arrayList2.add(pair.value);
        }
        super.setAttributes(arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new Object[arrayList2.size()]), coordinator);
        logger.traceReturn(THIS_CLASS, "setAttributes()");
    }

    protected Pair performSpecialHandllingAtSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        return new Pair(string, object);
    }

    private Pair handleDeprecatedAtSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        Pair pair = null;
        if (!this.setDeprecatedFromMap(string, object, coordinator)) {
            pair = this.setDeprecatedWithSpecialHandling(string, object, coordinator);
        }
        return pair;
    }

    private boolean setDeprecatedFromMap(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setDeprecatedFromMap(" + string + ")");
        boolean bl = false;
        Map map = this.getDeprecatedAttributesMap();
        Set set = map.keySet();
        if (set.contains(string)) {
            Object v = map.get(string);
            if (v instanceof List) {
                List list = (List)v;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.setDeprecatedAttributeOnOtherMo((Pair)iterator.next(), object, coordinator);
                }
            } else {
                this.setDeprecatedAttributeOnOtherMo((Pair)v, object, coordinator);
            }
            bl = true;
        }
        logger.traceReturn(THIS_CLASS, "setDeprecated(Attribute is depreicated [" + bl + "])");
        return bl;
    }

    protected Pair setDeprecatedWithSpecialHandling(String string, Object object, Coordinator coordinator) throws MoAccessException {
        return new Pair(string, object);
    }

    private void setDeprecatedAttributeOnOtherMo(Pair pair, Object object, Coordinator coordinator) throws MoAccessException {
        String string = pair.name;
        if (string != null) {
            String string2 = (String)pair.value;
            ManagedObject managedObject = this.getDeprecatedMo(string);
            managedObject.setAttribute(string2, object, coordinator);
        }
    }

    public final Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttribute(attributeName[" + string + "])");
        Object object = this.getDeprecated(string, coordinator);
        if (object == null) {
            object = super.getAttribute(string, this.getCoordinatorToUse(coordinator));
        }
        logger.traceReturn(THIS_CLASS, "getAttribute(returnValue[" + object + "])");
        return object;
    }

    public final Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object object = this.getDeprecated(string, coordinator);
            if (object == null) {
                arrayList.add(string);
                continue;
            }
            hashMap.put(string, object);
        }
        Object[] objectArray = super.getAttributes(arrayList.toArray(new String[arrayList.size()]), this.getCoordinatorToUse(coordinator));
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return this.combineAttributeLists(stringArray, arrayList, objectArray, hashMap);
    }

    protected Object getDeprecatedWithSpecialHandling(String string, Coordinator coordinator) throws MoAccessException {
        return null;
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws TransactionRequiredException, MoAccessException, ProcessingFailureException {
        this.registerAndStoreCoordinator(coordinator, false);
        super.release(managedObject, coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        this.registerAndStoreCoordinator(coordinator, false);
        super.reserve(managedObject, coordinator);
    }

    private Coordinator getCoordinatorToUse(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getCoordinatorToUse(coordinator[" + coordinator + "])");
        Coordinator coordinator2 = null;
        if (coordinator != null && this.lastTransactionUsed != null && coordinator.getTransactionID() == this.lastTransactionUsed.getTransactionID()) {
            coordinator2 = coordinator;
        }
        logger.traceReturn(THIS_CLASS, "getCoordinatorToUse(Coordinator[" + coordinator2 + "]");
        return coordinator2;
    }

    private Object getDeprecated(String string, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getDeprecated(attributeName[" + string + "])");
        Object object = null;
        Map map = this.getDeprecatedAttributesMap();
        Set set = map.keySet();
        if (set.contains(string)) {
            Object object2;
            Object v = map.get(string);
            Pair pair = null;
            if (v instanceof List) {
                object2 = (List)v;
                if (!object2.isEmpty()) {
                    pair = (Pair)object2.get(0);
                }
            } else {
                pair = (Pair)v;
            }
            if (pair != null) {
                object2 = pair.name;
                String string2 = (String)pair.value;
                ManagedObject managedObject = this.getDeprecatedMo((String)object2);
                object = managedObject.getAttribute(string2, coordinator);
            }
        } else {
            object = this.getDeprecatedWithSpecialHandling(string, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getDeprecated(" + object + ")");
        return object;
    }

    protected final Object getRawAttribute(String string, Coordinator coordinator) throws MoAccessException {
        return super.getAttribute(string, coordinator);
    }

    protected final void setRawAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        super.setAttribute(string, object, coordinator);
    }

    private ManagedObject getDeprecatedMo(String string) {
        logger.traceEnter(THIS_CLASS, "getDeprecatedMo(ldn = " + string + ")");
        AbstractGenericAttributeValidatorMao abstractGenericAttributeValidatorMao = null;
        abstractGenericAttributeValidatorMao = string.equals(this.getLocalDistinguishedName()) ? this : this.genericMaoContext.getMoRepositoryWrapper().lookup(string);
        logger.traceEnter(THIS_CLASS, "getDeprecatedMo()");
        return abstractGenericAttributeValidatorMao;
    }

    private Object[] combineAttributeLists(String[] stringArray, List list, Object[] objectArray, Map map) {
        logger.traceEnter(THIS_CLASS, "combineAttributeLists()");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = list.indexOf(string);
            if (n >= 0) {
                arrayList.add(objectArray[n]);
                continue;
            }
            arrayList.add(map.get(string));
        }
        logger.traceReturn(THIS_CLASS, "combineAttributeLists()");
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    private class ReplacementInfo {
        public String ldn;
        public String attributeName;
        public Object attributeValue;

        public ReplacementInfo(String string, String string2, Object object) {
            this.ldn = string;
            this.attributeName = string2;
            this.attributeValue = object;
        }
    }
}

