/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ArrayValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ArrayValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String[] attributesToCompareWith;

    public ArrayValidator(String string, String[] stringArray) {
        super(THIS_CLASS.getName(), string, true, true, false);
        logger.traceEnter(THIS_CLASS, "ArrayValidator()");
        this.attributesToCompareWith = stringArray;
        logger.traceReturn(THIS_CLASS, "ArrayValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtPrepare()");
        if (coordinator.getTransactionID() >= 0) {
            Object object = managedObject.getAttribute(this.attributeName, coordinator);
            for (int i = 0; i < this.attributesToCompareWith.length; ++i) {
                String string = this.attributesToCompareWith[i];
                if (this.attributeName.equals(string)) continue;
                Object object2 = managedObject.getAttribute(string, coordinator);
                this.checkSize(this.attributeName, string, object, object2);
            }
        }
        logger.traceReturn(THIS_CLASS, "validateAtPrepare()");
    }

    private void checkSize(String string, String string2, Object object, Object object2) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "checkSize()");
        Object[] objectArray = this.convertToObjectArray(object);
        Object[] objectArray2 = this.convertToObjectArray(object2);
        if (objectArray.length != objectArray2.length) {
            this.logAndThrowPrepareFailedException("The two arrays '" + string + "' [size=" + objectArray.length + "] and '" + string2 + "' [size=" + objectArray2.length + "] does not have the same size");
        }
        logger.traceReturn(THIS_CLASS, "checkSize()");
    }

    private Object[] convertToObjectArray(Object object) {
        logger.traceEnter(THIS_CLASS, "convertToObjectArray()");
        Object[] objectArray = new Object[]{};
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else if (object instanceof boolean[]) {
            objectArray = new Object[((boolean[])object).length];
        } else if (object instanceof int[]) {
            objectArray = new Object[((int[])object).length];
        } else {
            logger.traceAbnormal(THIS_CLASS, "Unsupported type used: " + object);
        }
        logger.traceReturn(THIS_CLASS, "convertToObjectArray(Object[] size = '" + objectArray.length + "')");
        return objectArray;
    }
}

