/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class BandClassPrioListValidator
extends AbstractAttributeValidator {
    private static final String CELL_RESELECTION_PRIORITY = "cellReselectionPriority";
    private static final String FREQ_CDMA = "freqCdma";
    private static final String HRPD_BAND_CLASS = "hrpdBandClass";
    private static final int VALUE_TO_IGNORE = -1000;
    private static final Class THIS_CLASS = BandClassPrioListValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public BandClassPrioListValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        Struct[] structArray = (Struct[])managedObject.getAttribute("bandClassPrioListCDMA2000", coordinator);
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            this.compareElementsInBandClassPrioList(structArray, i, struct);
        }
        logger.traceReturn(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
    }

    private void compareElementsInBandClassPrioList(Struct[] structArray, int n, Struct struct) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, PrepareFailedException {
        Integer n2 = (Integer)struct.getValue(HRPD_BAND_CLASS);
        Integer n3 = (Integer)struct.getValue(FREQ_CDMA);
        for (int i = 0; i < structArray.length; ++i) {
            if (i == n || !n2.equals(structArray[i].getValue(HRPD_BAND_CLASS))) continue;
            this.sameCellReselectionPrioInHrpdBandClass(structArray, struct, i);
            this.isPairOfFreqCdmaAndHrpdBandClassUnique(structArray, n3, i);
        }
    }

    private void isPairOfFreqCdmaAndHrpdBandClassUnique(Struct[] structArray, Integer n, int n2) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, PrepareFailedException {
        if (n != -1000 && n.equals(structArray[n2].getValue(FREQ_CDMA))) {
            String string = "The pair of hrpdBandClass [" + structArray[n2].getValue(HRPD_BAND_CLASS) + "] and freqCdma [" + structArray[n2].getValue(FREQ_CDMA) + "] must be unique in the bandClassPrioListCDMA2000.";
            this.logAndThrowPrepareFailedException(string);
        }
    }

    private void sameCellReselectionPrioInHrpdBandClass(Struct[] structArray, Struct struct, int n) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, PrepareFailedException {
        Integer n2 = (Integer)struct.getValue(CELL_RESELECTION_PRIORITY);
        if (n2 != -1000 && !n2.equals(structArray[n].getValue(CELL_RESELECTION_PRIORITY))) {
            String string = "The cellReselectionPriority [" + structArray[n].getValue(CELL_RESELECTION_PRIORITY) + "] must be the same within a hrpdBandClass [" + structArray[n].getValue(HRPD_BAND_CLASS) + "].";
            this.logAndThrowPrepareFailedException(string);
        }
    }
}

