/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class Cdma2000ChannelNumberValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = Cdma2000ChannelNumberValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String VALIDATION_FAIL_MESSAGE = "The value for attribute freqCdma must be unique among all frequencies under the same frequency band.";

    public Cdma2000ChannelNumberValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, THIS_CLASS.getName() + "(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, THIS_CLASS.getName() + "()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        Object object = managedObject.getAttribute("freqCdma", coordinator);
        ManagedObject managedObject2 = managedObject.getParent();
        MoIterator moIterator = managedObject2.getChildren();
        while (moIterator != null && moIterator.hasMoreElements()) {
            Object object2;
            ManagedObject managedObject3 = (ManagedObject)moIterator.nextElement();
            String string = managedObject3.getLocalDistinguishedName();
            if (MoCheck.isMoNotReadable(managedObject3) || string.equals(managedObject.getLocalDistinguishedName()) || !object.equals(object2 = managedObject3.getAttribute("freqCdma", coordinator))) continue;
            this.logAndThrowPrepareFailedException(VALIDATION_FAIL_MESSAGE);
        }
    }
}

