/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class CheckEarfcnRangeValidator
extends AbstractAttributeValidator {
    private static final String EXTERNAL_EUTRAN_CELL_TDD = "ExternalEUtranCellTDD";
    private static final String EXTERNAL_EUTRAN_CELL_FDD = "ExternalEUtranCellFDD";
    private static final String ARFCN_VALUE_E_UTRAN_DL = "arfcnValueEUtranDl";
    private static final Class THIS_CLASS = CheckEarfcnRangeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public CheckEarfcnRangeValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(this.attributeName, coordinator);
        Integer n = (Integer)managedObject2.getAttribute(ARFCN_VALUE_E_UTRAN_DL, coordinator);
        this.validateEarfcn(managedObject.getType(), n, managedObject2);
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void validateEarfcn(String string, int n, ManagedObject managedObject) throws PrepareFailedException {
        if (string.equals(EXTERNAL_EUTRAN_CELL_FDD)) {
            this.validateFDDFreq(n, managedObject);
        } else if (string.equals(EXTERNAL_EUTRAN_CELL_TDD)) {
            this.validateTDDFreq(n, managedObject);
        }
    }

    private void validateFDDFreq(int n, ManagedObject managedObject) throws PrepareFailedException {
        if (n >= 18000 && n <= 46589 || n > 262143) {
            String string = "It is only possible to configure a reference to a EUtranFrequency with a FDD ARFCN. The reference [" + managedObject.getLocalDistinguishedName() + "] with earfcn [" + n + "] is not valid.";
            this.logAndThrowPrepareFailedException(string);
        }
    }

    private void validateTDDFreq(int n, ManagedObject managedObject) throws PrepareFailedException {
        if (n < 36000 || n > 262143) {
            String string = "It is only possible to configure a reference to a EUtranFrequency with a TDD ARFCN. The reference [" + managedObject.getLocalDistinguishedName() + "] with earfcn [" + n + "] is not valid.";
            this.logAndThrowPrepareFailedException(string);
        }
    }
}

