/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class DistributionInfoValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = DistributionInfoValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public DistributionInfoValidator(String string) {
        super(THIS_CLASS.getName(), string, true, false, false);
        logger.traceEnter(THIS_CLASS, "DistributionInfoValidator(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, "DistributionInfoValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        Struct struct = (Struct)managedObject.getAttribute(this.attributeName, coordinator);
        this.checkIntegerListSumWithinLimit(struct, "freqDistributionList", 100);
        this.checkTwoListsHaveSameSize(struct, "eUtranFreqRefList", "freqDistributionList");
    }

    private void checkTwoListsHaveSameSize(Struct struct, String string, String string2) throws PrepareFailedException, NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        Object[] objectArray;
        Object[] objectArray2 = (Object[])struct.getValue(string);
        if (objectArray2.length != (objectArray = (Object[])struct.getValue(string2)).length) {
            this.logAndThrowPrepareFailedException("The " + string + " and " + string2 + " under attribute " + this.attributeName + " do not have the same size. Change them to continue.");
        }
    }

    private void checkIntegerListSumWithinLimit(Struct struct, String string, int n) throws PrepareFailedException, NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        int n2 = 0;
        Integer[] integerArray = (Integer[])struct.getValue(string);
        for (int i = 0; i < integerArray.length; ++i) {
            n2 += integerArray[i].intValue();
        }
        if (n2 > n) {
            this.logAndThrowPrepareFailedException("The sum of elements in " + string + " under attribute " + this.attributeName + " is over the limit " + n + ". Change it to continue.");
        }
    }
}

