/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class EarfcnDlUlRangeValidator
extends AbstractAttributeValidator {
    private static final String UE_MEAS_CONTROL = "UeMeasControl";
    private static final Class THIS_CLASS = EarfcnDlUlRangeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext genericMaoContext;
    private static final int MR29174_ACTIVATED = 1;
    private static final String EARFCNDL = "earfcndl";
    private static final String EARFCNUL = "earfcnul";
    private static final int OFFSET_B01_B28 = 18000;
    private static final int OFFSET_B30_B31 = 17890;
    private static final int OFFSET_B65_B66 = 65536;
    private static final int NOT_APLICABLE = 0;

    public EarfcnDlUlRangeValidator(String string, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.genericMaoContext = genericMaoContext;
        logger.traceEnter(THIS_CLASS, "EarfcnDlUlRangeValidator(attributeName[" + this.attributeName + "])");
        logger.traceReturn(THIS_CLASS, "EarfcnDlUlRangeValidator()");
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtPrepare()");
        boolean bl = this.getZzzTemporary6(managedObject) == 1;
        Integer n = (Integer)managedObject.getAttribute(EARFCNDL, coordinator);
        Integer n2 = (Integer)managedObject.getAttribute(EARFCNUL, coordinator);
        if (!this.checkMr29174(bl, n, n2) && !this.globalCheck(n, n2)) {
            this.logAndThrowPrepareFailedException("Earfcnul must be equal to [earfcndl + 18000(or 17890)] or [0] for DL only bands. Earfcndl is [" + n + "], earfcnul is [" + n2 + "]");
        }
        logger.traceReturn(THIS_CLASS, "validateAtPrepare(result=false)");
    }

    private boolean globalCheck(Integer n, Integer n2) {
        boolean bl = false;
        bl = n2 == 0 ? this.globalCheckUl(n, n2) : this.globalCheckDl(n, n2);
        return bl;
    }

    private boolean globalCheckDl(Integer n, Integer n2) {
        boolean bl = false;
        if (n <= 9659) {
            bl = n2 == n + 18000;
        } else if (n >= 9770 && n <= 9919) {
            bl = n2 == n + 17890;
        } else if (n >= 65536 && n <= 67135) {
            bl = n2 == n + 65536;
        }
        return bl;
    }

    private boolean globalCheckUl(Integer n, Integer n2) {
        boolean bl = false;
        if (n2 == 0) {
            bl = n >= 9660 && n <= 9769 || n >= 9920 && n <= 10359 || n >= 67136 && n <= 67535 || n >= 255144 && n <= 256143 || n >= 260894 && n <= 262143;
        }
        return bl;
    }

    private boolean checkMr29174(boolean bl, Integer n, Integer n2) {
        return bl && n2 == 19600 && n == 1550;
    }

    private int getZzzTemporary6(ManagedObject managedObject) {
        int n = 0;
        try {
            MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(UE_MEAS_CONTROL);
            while (moIterator != null && moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = (ManagedObject)moIterator.nextElement();
                String string = managedObject2.getParent().getFullDistinguishedName();
                if (!managedObject.getFullDistinguishedName().equals(string)) continue;
                n = (Integer)managedObject2.getAttribute("zzzTemporary6", null);
                break;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }
}

