/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class EarfcnGenericAttributeValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = EarfcnGenericAttributeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EUTRAN_CELL_RELATION = "EUtranCellRelation";
    private static final String NEIGHOUR_CELL_REF = "neighborCellRef";
    private static final String EUTRAN_FREQUENCY_REF = "eutranFrequencyRef";
    private static final String ARFCN_VALUE_EUTRAN_DL = "arfcnValueEUtranDl";
    private final GenericMaoContext genericMaoContext;
    private final String moType;

    public EarfcnGenericAttributeValidator(String string, String string2, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.genericMaoContext = genericMaoContext;
        this.moType = string2;
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject.getLocalDistinguishedName() + ")");
        this.validateEarfcndl(managedObject, coordinator);
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void validateEarfcndl(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateEarfcndl(Mo to validate: " + managedObject.getLocalDistinguishedName() + ")");
        Object object = managedObject.getAttribute(this.attributeName, coordinator);
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(EUTRAN_CELL_RELATION);
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = (ManagedObject)moIterator.nextElement();
            if (MoCheck.isMoNotReadable(managedObject2)) continue;
            ManagedObject managedObject3 = managedObject2.getParent();
            ManagedObject managedObject4 = (ManagedObject)managedObject2.getAttribute(NEIGHOUR_CELL_REF, coordinator);
            if (!managedObject4.getType().equals(this.moType) || !managedObject4.getLocalDistinguishedName().equals(managedObject.getLocalDistinguishedName())) continue;
            ManagedObject managedObject5 = (ManagedObject)managedObject3.getAttribute(EUTRAN_FREQUENCY_REF, coordinator);
            Object object2 = managedObject5.getAttribute(ARFCN_VALUE_EUTRAN_DL, coordinator);
            if (object2.equals(object)) break;
            String string = "The value '" + object + "' for MO '" + managedObject2.getLocalDistinguishedName() + "' is not the same as the value '" + object2 + "' for MO '" + managedObject5.getLocalDistinguishedName() + "'";
            this.logAndThrowPrepareFailedException(string);
            break;
        }
        logger.traceReturn(THIS_CLASS, "validateEarfcndl(Mo to validate: " + managedObject.getLocalDistinguishedName() + ")");
    }
}

