/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ForbiddenChangeAttributeValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ForbiddenChangeAttributeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String[] attributeNames;
    private final Object[] attributeValues;
    private boolean ongoingCreate = false;

    public ForbiddenChangeAttributeValidator(String string, String[] stringArray, Object[] objectArray) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.attributeNames = stringArray;
        this.attributeValues = objectArray;
    }

    public void validateAtCreate(ManagedObject managedObject, Object object, AttrList attrList, Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtCreate(ManagedObject " + managedObject + " ,...)");
        this.ongoingCreate = true;
        logger.traceReturn(THIS_CLASS, "validateAtCreate()");
        super.validateAtCreate(managedObject, object, attrList, coordinator);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        Object object;
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        if (this.ongoingCreate) {
            logger.traceReturn(THIS_CLASS, "validate(ManagedObject " + managedObject + ") ongoing create skipping validation");
            return;
        }
        Object object2 = managedObject.getAttribute(this.attributeName, null);
        if (!object2.equals(object = managedObject.getAttribute(this.attributeName, coordinator))) {
            for (int i = 0; i < this.attributeNames.length; ++i) {
                Object object3 = managedObject.getAttribute(this.attributeNames[i], null);
                if (object3 == null || !object3.equals(this.attributeValues[i])) continue;
                String string = "Forbidden to change attribute " + managedObject.getType() + "." + this.attributeName + " when " + managedObject.getType() + "." + this.attributeNames[i] + " is set to " + this.attributeValues[i];
                this.logAndThrowPrepareFailedException(string);
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    public void handlePostSet(ManagedObject managedObject, String string, Object object) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handlePostSet(ManagedObject " + managedObject + ", attribute " + string + ", value " + object + ")");
        this.ongoingCreate = false;
        logger.traceReturn(THIS_CLASS, "handlePostSet(ManagedObject " + managedObject + ")");
        super.handlePostSet(managedObject, string, object);
    }
}

