/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ForbiddenCombinationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ForbiddenCombinationValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Object moAttribute;
    private final String moTypeToMatch;
    private final String moTypeToMatchsAttributeName;
    private final GenericMaoContext genericMaoContext;
    private final Object moTypeToMatchsAttributeNameValue;
    private final String moAttributeName;

    public ForbiddenCombinationValidator(Object object, String string, String string2, String string3, Object object2, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.moAttribute = object;
        this.moAttributeName = string;
        this.moTypeToMatch = string2;
        this.moTypeToMatchsAttributeName = string3;
        this.moTypeToMatchsAttributeNameValue = object2;
        this.genericMaoContext = genericMaoContext;
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        this.validateForbiddenAttribute(managedObject, coordinator);
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void validateForbiddenAttribute(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        Object object = managedObject.getAttribute(this.moAttributeName, coordinator);
        if (object.equals(this.moAttribute)) {
            MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(this.moTypeToMatch);
            while (moIterator != null && moIterator.hasMoreElements()) {
                Object object2;
                ManagedObject managedObject2 = (ManagedObject)moIterator.nextElement();
                if (MoCheck.isMoNotReadable(managedObject2) || !this.moTypeToMatchsAttributeNameValue.equals(object2 = managedObject2.getAttribute(this.moTypeToMatchsAttributeName, coordinator))) continue;
                String string = "The combination MO[" + managedObject.getLocalDistinguishedName() + "], Attribute[" + this.moAttributeName + "], Value[" + object + "] is not valid together with MO[" + managedObject2.getLocalDistinguishedName() + "], Attribute[" + this.moTypeToMatchsAttributeName + "], Value[" + object2 + "]";
                this.logAndThrowPrepareFailedException(string);
            }
        }
    }
}

