/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ForbiddenSetAttributeValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ForbiddenSetAttributeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String[] moTypesToCheck;
    private final String[] attributeNamesToCheck;
    private final Object[] forbiddenAttributeValues;
    private final GenericMaoContext genericMaoContext;
    private boolean ongoingCreate = false;

    public ForbiddenSetAttributeValidator(String string, String[] stringArray, String[] stringArray2, Object[] objectArray, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, true, true, false);
        this.moTypesToCheck = stringArray;
        this.attributeNamesToCheck = stringArray2;
        this.forbiddenAttributeValues = objectArray;
        this.genericMaoContext = genericMaoContext;
    }

    public void validateAtCreate(ManagedObject managedObject, Object object, AttrList attrList, Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtCreate(ManagedObject " + managedObject + " ,...)");
        this.ongoingCreate = true;
        logger.traceReturn(THIS_CLASS, "validateAtCreate()");
        super.validateAtCreate(managedObject, object, attrList, coordinator);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        if (this.ongoingCreate) {
            logger.traceReturn(THIS_CLASS, "validate(ManagedObject " + managedObject + ") ongoing create skipping validation");
            return;
        }
        this.validateForbiddenAttributes(managedObject, coordinator);
        logger.traceReturn(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
    }

    private void validateForbiddenAttributes(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, PrepareFailedException {
        for (int i = 0; i < this.moTypesToCheck.length; ++i) {
            MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(this.moTypesToCheck[i]);
            while (moIterator != null && moIterator.hasMoreElements()) {
                Object object;
                ManagedObject managedObject2 = (ManagedObject)moIterator.nextElement();
                if (MoCheck.isMoNotReadable(managedObject2) || (object = managedObject2.getAttribute(this.attributeNamesToCheck[i], coordinator)) == null || !object.equals(this.forbiddenAttributeValues[i])) continue;
                String string = "Forbidden to change attribute " + managedObject.getType() + "." + this.attributeName + " when " + this.moTypesToCheck[i] + "." + this.attributeNamesToCheck[i] + " = " + this.forbiddenAttributeValues[i];
                this.logAndThrowPrepareFailedException(string);
            }
        }
    }

    public void handlePostSet(ManagedObject managedObject, String string, Object object) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handlePostSet(ManagedObject " + managedObject + ", attribute " + string + ", value " + object + ")");
        this.ongoingCreate = false;
        logger.traceReturn(THIS_CLASS, "handlePostSet(ManagedObject " + managedObject + ")");
        super.handlePostSet(managedObject, string, object);
    }
}

