/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class GeranFreqGroupRelationIndirectRelationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = GeranFreqGroupRelationIndirectRelationValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String GERAN_FREQUENCY_TYPE = "GeranFrequency";
    private static final String GERAN_FREQ_GROUP_RELATION_TYPE = "GeranFreqGroupRelation";
    private static final String GERAN_FREQ_GROUP_REF = "geranFreqGroupRef";
    private static final String RESERVED_BY = "reservedBy";
    protected static final String VALIDATION_FAIL_MESSAGE = " cell has already indirect relation to ";

    public GeranFreqGroupRelationIndirectRelationValidator(String string) {
        super(THIS_CLASS.getName(), string, true, false, false);
        logger.traceEnter(THIS_CLASS, THIS_CLASS.getName() + "(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, THIS_CLASS.getName() + "()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        Object object;
        ManagedObject managedObject2;
        Object object2;
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject3 = (ManagedObject)managedObject.getAttribute(GERAN_FREQ_GROUP_REF, coordinator);
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject3.getAttribute(RESERVED_BY, coordinator);
        List list = this.extractGeranFrequencies(managedObjectArray);
        ManagedObject managedObject4 = managedObject.getParent();
        ArrayList arrayList = new ArrayList();
        MoIterator moIterator = managedObject4.getChildren();
        while (moIterator.hasMoreElements()) {
            object2 = moIterator.nextMo();
            if (object2.equals(managedObject) || !object2.getType().equals(GERAN_FREQ_GROUP_RELATION_TYPE)) continue;
            managedObject2 = (ManagedObject)object2.getAttribute(GERAN_FREQ_GROUP_REF, coordinator);
            object = (ManagedObject[])managedObject2.getAttribute(RESERVED_BY, coordinator);
            arrayList.addAll(this.extractGeranFrequencies((ManagedObject[])object));
        }
        object2 = list.iterator();
        while (object2.hasNext()) {
            managedObject2 = (ManagedObject)object2.next();
            if (!arrayList.contains(managedObject2)) continue;
            object = managedObject4.getLocalDistinguishedName() + VALIDATION_FAIL_MESSAGE + managedObject2.getLocalDistinguishedName();
            this.logAndThrowPrepareFailedException((String)object);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private List extractGeranFrequencies(ManagedObject[] managedObjectArray) {
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!GERAN_FREQUENCY_TYPE.equals(managedObjectArray[i].getType())) continue;
            arrayList.add(managedObjectArray[i]);
        }
        return arrayList;
    }
}

