/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.MoIteratorImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.validator.SameMoTypeValidator;

public class GeranFreqGroupRelationValidator
extends SameMoTypeValidator {
    private static final Class THIS_CLASS = GeranFreqGroupRelationValidator.class;
    private static final String GERAN_FREQUENCY_REF = "geranFrequencyRef";
    private static final String GERAN_FREQ_GROUP_REF = "geranFreqGroupRef";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public GeranFreqGroupRelationValidator(String string, GenericMaoContext genericMaoContext) {
        super(string, true, genericMaoContext);
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(this.attributeName, coordinator);
        if (null != managedObject2) {
            super.validate(managedObject, coordinator);
            ManagedObject managedObject3 = (ManagedObject)managedObject2.getAttribute(GERAN_FREQUENCY_REF, coordinator);
            ManagedObject[] managedObjectArray = (ManagedObject[])managedObject3.getAttribute(GERAN_FREQ_GROUP_REF, coordinator);
            ManagedObject managedObject4 = (ManagedObject)managedObject.getParent().getAttribute(GERAN_FREQ_GROUP_REF, coordinator);
            boolean bl = false;
            if (managedObjectArray != null) {
                bl = this.isAnyLdnMatchesRelatedGeranFreqGroupLdn(managedObjectArray, managedObject4.getLocalDistinguishedName());
            }
            if (!bl) {
                String string = "The attribute geranFreqGroupRef in " + managedObject3.getLocalDistinguishedName() + " should contain a reference to " + managedObject4.getLocalDistinguishedName() + " since it is referred by " + managedObject2.getLocalDistinguishedName();
                this.logAndThrowPrepareFailedException(string);
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private boolean isAnyLdnMatchesRelatedGeranFreqGroupLdn(ManagedObject[] managedObjectArray, String string) {
        boolean bl = false;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!string.equals(managedObjectArray[i].getLocalDistinguishedName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected MoIterator getMoIterator(ManagedObject managedObject) {
        logger.traceEnter(THIS_CLASS, "getMoIterator()");
        MoIterator moIterator = super.getMoIterator(managedObject);
        ManagedObject managedObject2 = managedObject.getParent().getParent();
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject3 = moIterator.nextMo();
            if (!managedObject3.getParent().getParent().equals(managedObject2)) continue;
            arrayList.add(managedObject3);
        }
        logger.traceReturn(THIS_CLASS, "getMoIterator()");
        return new MoIteratorImpl(arrayList);
    }
}

