/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class GeranFrequencyIndirectRelationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = GeranFrequencyIndirectRelationValidator.class;
    private static final String GERAN_FREQ_GROUP_RELATION_TYPE = "GeranFreqGroupRelation";
    private static final String RESERVED_BY = "reservedBy";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String VALIDATION_FAIL_MESSAGE = " has already indirect relation to ";

    public GeranFrequencyIndirectRelationValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, THIS_CLASS.getName() + "(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, THIS_CLASS.getName() + "()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute("geranFreqGroupRef", coordinator);
        if (0 != managedObjectArray.length) {
            HashSet hashSet = new HashSet();
            for (int i = 0; i < managedObjectArray.length; ++i) {
                ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObjectArray[i].getAttribute(RESERVED_BY, coordinator);
                this.isIndirectRelationPresent(hashSet, this.extractGeranFreqGroupRelations(managedObjectArray2), managedObject);
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void isIndirectRelationPresent(Set set, List list, ManagedObject managedObject) throws PrepareFailedException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject2 = (ManagedObject)iterator.next();
            if (set.add(managedObject2.getParent())) continue;
            this.logAndThrowPrepareFailedException(managedObject2.getParent().getLocalDistinguishedName() + VALIDATION_FAIL_MESSAGE + managedObject.getLocalDistinguishedName());
        }
    }

    private List extractGeranFreqGroupRelations(ManagedObject[] managedObjectArray) {
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!GERAN_FREQ_GROUP_RELATION_TYPE.equals(managedObjectArray[i].getType())) continue;
            arrayList.add(managedObjectArray[i]);
        }
        return arrayList;
    }
}

