/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class GeranRelationConsistencyValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = GeranRelationConsistencyValidator.class;
    private static final String GERAN_FREQ_GROUP_RELATION_TYPE = "GeranFreqGroupRelation";
    private static final String RESERVED_BY = "reservedBy";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String VALIDATION_FAIL_MESSAGE = " would be broken after that action. ";

    public GeranRelationConsistencyValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, THIS_CLASS.getName() + "(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, THIS_CLASS.getName() + "()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute("geranFreqGroupRef", coordinator);
        ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObject.getAttribute(RESERVED_BY, coordinator);
        if (0 != managedObjectArray.length || 0 != managedObjectArray2.length) {
            int n;
            HashSet hashSet = new HashSet();
            for (n = 0; n < managedObjectArray.length; ++n) {
                ManagedObject[] managedObjectArray3 = (ManagedObject[])managedObjectArray[n].getAttribute(RESERVED_BY, coordinator);
                hashSet.addAll(this.extractGeranFreqGroupRelations(managedObjectArray3));
            }
            for (n = 0; n < managedObjectArray2.length; ++n) {
                this.isRelationConsistent(hashSet, managedObjectArray2[n], coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void isRelationConsistent(Set set, ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute(RESERVED_BY, coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!set.add(managedObjectArray[i].getParent())) continue;
            this.logAndThrowPrepareFailedException(managedObjectArray[i].getLocalDistinguishedName() + VALIDATION_FAIL_MESSAGE);
        }
    }

    private List extractGeranFreqGroupRelations(ManagedObject[] managedObjectArray) {
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!GERAN_FREQ_GROUP_RELATION_TYPE.equals(managedObjectArray[i].getType())) continue;
            arrayList.add(managedObjectArray[i]);
        }
        return arrayList;
    }
}

