/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.GetChildrenByTypeHelper;

public class IdleModePrioAtReleaseRefValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = IdleModePrioAtReleaseRefValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String MO_TYPE_EUTRAN_FREQ_RELATION = "EUtranFreqRelation";
    public static final String MO_ATTR_EUTRAN_FREQUENCY_REF = "eutranFrequencyRef";
    public static final String MO_ATTR_IDLE_MODE_PRIO_AT_RELEASE_REF = "idleModePrioAtReleaseRef";
    private final String[] distInfoAttrNames;

    public IdleModePrioAtReleaseRefValidator(String[] stringArray) {
        super(THIS_CLASS.getName(), MO_ATTR_IDLE_MODE_PRIO_AT_RELEASE_REF, false, true, false);
        logger.traceEnter(THIS_CLASS, "IdleModePrioAtReleaseRefValidator(attribute idleModePrioAtReleaseRef)");
        this.distInfoAttrNames = stringArray;
        logger.traceReturn(THIS_CLASS, "IdleModePrioAtReleaseRefValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(this.attributeName, coordinator);
        if (managedObject2 != null) {
            Set set = this.getFreqsFromCell(managedObject, coordinator);
            for (int i = 0; i < this.distInfoAttrNames.length; ++i) {
                Struct struct = (Struct)managedObject2.getAttribute(this.distInfoAttrNames[i], coordinator);
                ManagedObject[] managedObjectArray = (ManagedObject[])struct.getValue("eUtranFreqRefList");
                for (int j = 0; j < managedObjectArray.length; ++j) {
                    if (set.contains(managedObjectArray[j])) continue;
                    String string = "It is not allowed to set the idleModePrioAtReleaseRef to the MO [" + managedObject2.getLocalDistinguishedName() + "]. The cell does not have a " + "relationship with the frequency [" + managedObjectArray[j].getLocalDistinguishedName() + "] that is included in " + this.distInfoAttrNames[i] + ".";
                    this.logAndThrowPrepareFailedException(string);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private Set getFreqsFromCell(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        List list = GetChildrenByTypeHelper.getInstance().getAllChildrenByTypeFromMo(managedObject, MO_TYPE_EUTRAN_FREQ_RELATION);
        HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
        for (int i = 0; i < list.size(); ++i) {
            ManagedObject managedObject2 = (ManagedObject)((ManagedObject)list.get(i)).getAttribute(MO_ATTR_EUTRAN_FREQUENCY_REF, coordinator);
            hashSet.add(managedObject2);
        }
        return hashSet;
    }
}

