/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ImeisvFeaturesListsValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ImeisvFeaturesListsValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String attrListOfFeaturesOff = "";
    private String attrListOfFeaturesOn = "";
    private Integer[] listOfFeaturesOff = new Integer[0];
    private Integer[] listOfFeaturesOn = new Integer[0];

    public ImeisvFeaturesListsValidator(String string) {
        super(THIS_CLASS.getName(), string, true, true, false);
    }

    private void getAttributesToValidate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        String string = managedObject.getType();
        if (string.equals("ImeisvTable")) {
            this.listOfFeaturesOff = (Integer[])managedObject.getAttribute("listOfFeaturesDefaultOff", coordinator);
            this.attrListOfFeaturesOff = "listOfFeaturesDefaultOff";
            this.listOfFeaturesOn = (Integer[])managedObject.getAttribute("listOfFeaturesDefaultOn", coordinator);
            this.attrListOfFeaturesOn = "listOfFeaturesDefaultOn";
        } else if (string.equals("ImeisvProfile")) {
            this.listOfFeaturesOff = (Integer[])managedObject.getAttribute("listOfFeaturesToTurnOff", coordinator);
            this.attrListOfFeaturesOff = "listOfFeaturesToTurnOff";
            this.listOfFeaturesOn = (Integer[])managedObject.getAttribute("listOfFeaturesToTurnOn", coordinator);
            this.attrListOfFeaturesOn = "listOfFeaturesToTurnOn";
        } else {
            logger.traceAbnormal(THIS_CLASS, "Unsupported type used: " + string);
        }
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        this.getAttributesToValidate(managedObject, coordinator);
        if (this.listOfFeaturesOff.length != 0 && this.listOfFeaturesOn.length != 0) {
            for (int i = 0; i < this.listOfFeaturesOn.length; ++i) {
                for (int j = 0; j < this.listOfFeaturesOff.length; ++j) {
                    if (!this.listOfFeaturesOn[i].equals(this.listOfFeaturesOff[j])) continue;
                    this.logAndThrowPrepareFailedException("Requested combination is not valid. " + this.attrListOfFeaturesOff + " and " + this.attrListOfFeaturesOn + " must be disjoint sets.");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }
}

