/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.GetChildrenByTypeHelper;

public class IncludeInSystemInfo1xRttValidator
extends AbstractAttributeValidator {
    private static final String MOTYPE_CDMA2000_1XRTT_BAND_RELATION = "Cdma20001xRttBandRelation";
    private static final String MOTYPE_CDMA2000_1XRTT_CELL_RELATION = "Cdma20001xRttCellRelation";
    private static final String MOTYPE_CDMA2000_1XRTT_FREQ_RELATION = "Cdma20001xRttFreqRelation";
    private static final String ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION = "includeInSystemInformation";
    private static final String ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION_REL9 = "includeInSystemInformationRel9";
    private static final Class THIS_CLASS = IncludeInSystemInfo1xRttValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public IncludeInSystemInfo1xRttValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(mo[" + managedObject.getLocalDistinguishedName() + "])");
        Boolean bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION, coordinator);
        Boolean bl2 = (Boolean)managedObject.getAttribute(ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION_REL9, coordinator);
        if (bl.booleanValue() && bl2.booleanValue()) {
            this.logAndThrowPrepareFailedException("The referred cell shall only set one of the attributes (includeInSystemInformation or includeInSystemInformationRel9) value to true");
        }
        if (bl.booleanValue() || bl2.booleanValue()) {
            this.validateChildrenUnderFreq(managedObject, coordinator);
            this.validateChildrenCellWithIncludeInSystemInformaionTrue(managedObject, coordinator);
            this.validateChildrenCellTotal(managedObject, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void validateChildrenUnderFreq(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateChildrenUnderFreq()");
        List list = GetChildrenByTypeHelper.getInstance().getAllChildrenByTypeFromMo(managedObject.getParent(), MOTYPE_CDMA2000_1XRTT_CELL_RELATION);
        this.validateNumberOfIncludeInsystemInformationTotal(list, coordinator, 16, MOTYPE_CDMA2000_1XRTT_CELL_RELATION);
        logger.traceReturn(THIS_CLASS, "validateChildrenUnderFreq()");
    }

    private void validateChildrenCellWithIncludeInSystemInformaionTrue(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateChildrenCellsWithIncludeInSystemInformaionTrue()");
        List list = GetChildrenByTypeHelper.getInstance().getAllGreatGrandChildrenByTypeFromMo(managedObject.getParent().getParent().getParent(), MOTYPE_CDMA2000_1XRTT_BAND_RELATION, MOTYPE_CDMA2000_1XRTT_FREQ_RELATION, MOTYPE_CDMA2000_1XRTT_CELL_RELATION);
        this.validateNumberOfIncludeInsystemInformation(list, coordinator, 32, "EUtranCell");
        logger.traceEnter(THIS_CLASS, "validateChildrenCellsWithIncludeInSystemInformaionTrue()");
    }

    private void validateChildrenCellTotal(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateChildrenCellTotal()");
        List list = GetChildrenByTypeHelper.getInstance().getAllGreatGrandChildrenByTypeFromMo(managedObject.getParent().getParent().getParent(), MOTYPE_CDMA2000_1XRTT_BAND_RELATION, MOTYPE_CDMA2000_1XRTT_FREQ_RELATION, MOTYPE_CDMA2000_1XRTT_CELL_RELATION);
        this.validateNumberOfIncludeInsystemInformationTotal(list, coordinator, 40, "EUtranCell");
        logger.traceEnter(THIS_CLASS, "validateChildrenCellTotal()");
    }

    private void validateNumberOfIncludeInsystemInformationTotal(List list, Coordinator coordinator, int n, String string) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        String string2;
        boolean bl;
        logger.traceEnter(THIS_CLASS, "validateNumberOfIncludeInsystemInformation()");
        int n2 = this.countIncludeInSystemInformationTotal(list, coordinator);
        int n3 = this.countIncludeInSystemInformation(list, coordinator);
        boolean bl2 = bl = n2 <= n;
        if (n2 == n && n3 == 0) {
            string2 = "It is not allowed to have " + n + " Cdma20001xRttCellRelation " + "with the attribute 'includeInSystemInformation = false' and 'includeInSystemInformationRel9 = true' under the " + string + ". You need to make sure that you have at least one of the " + n + " Cdma20001xRttCellRelation " + "with the attribute 'includeInSystemInformation = true' and 'includeInSystemInformationRel9 = false'";
            this.logAndThrowPrepareFailedException(string2);
        }
        if (n2 > n) {
            string2 = "It is not allowed to have more then " + n + " Cdma20001xRttCellRelation " + "with the attribute 'includeInSystemInformation = true' or 'includeInSystemInformationRel9 = true' under the " + string + ", actual = " + n2;
            this.logAndThrowPrepareFailedException(string2);
        }
        logger.traceReturn(THIS_CLASS, "validateNumberOfIncludeInsystemInformation(" + bl + ")");
    }

    private void validateNumberOfIncludeInsystemInformation(List list, Coordinator coordinator, int n, String string) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        boolean bl;
        logger.traceEnter(THIS_CLASS, "validateNumberOfIncludeInsystemInformation()");
        int n2 = this.countIncludeInSystemInformation(list, coordinator);
        boolean bl2 = bl = n2 <= n;
        if (n2 > n) {
            String string2 = "It is not allowed to have more then " + n + " Cdma20001xRttCellRelation " + "with the attribute 'includeInSystemInformation = true' under the " + string + ", actual = " + n2;
            this.logAndThrowPrepareFailedException(string2);
        }
        logger.traceReturn(THIS_CLASS, "validateNumberOfIncludeInsystemInformation(" + bl + ")");
    }

    private int countIncludeInSystemInformationTotal(List list, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "countIncludeInSystemInformationTotal()");
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject = (ManagedObject)iterator.next();
            if (MoCheck.isMoNotReadable(managedObject)) continue;
            Boolean bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION, coordinator);
            Boolean bl2 = (Boolean)managedObject.getAttribute(ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION_REL9, coordinator);
            if (!bl.booleanValue() && !bl2.booleanValue()) continue;
            ++n;
        }
        logger.traceReturn(THIS_CLASS, "countIncludeInSystemInformationTotal(count[" + n + "])");
        return n;
    }

    private int countIncludeInSystemInformation(List list, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "countIncludeInSystemInformation()");
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Boolean bl;
            ManagedObject managedObject = (ManagedObject)iterator.next();
            if (MoCheck.isMoNotReadable(managedObject) || !(bl = (Boolean)managedObject.getAttribute(ATTRIBUTE_INCLUDE_IN_SYSTEM_INFORMATION, coordinator)).booleanValue()) continue;
            ++n;
        }
        logger.traceReturn(THIS_CLASS, "countIncludeInSystemInformation(count[" + n + "])");
        return n;
    }
}

