/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.GetChildrenByTypeHelper;

public class IncludeInSystemInfoListValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = IncludeInSystemInfoListValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final ManagedObject eUtranCellXdd;
    private final String eUtranCellEarfcnAttributeName;

    public IncludeInSystemInfoListValidator(ManagedObject managedObject, String string, String string2) {
        super(THIS_CLASS.getName(), string2, false, true, false);
        logger.traceEnter(THIS_CLASS, "IncludeInSystemInfoListValidator()");
        this.eUtranCellXdd = managedObject;
        this.eUtranCellEarfcnAttributeName = string;
        logger.traceReturn(THIS_CLASS, "IncludeInSystemInfoListValidator()");
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtPrepare()");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Boolean bl = (Boolean)managedObject.getAttribute("includeInSystemInformation", coordinator);
        Integer n = (Integer)managedObject.getAttribute("qOffsetCellEUtran", coordinator);
        Boolean bl2 = (Boolean)managedObject.getAttribute("isHoAllowed", coordinator);
        if (bl.booleanValue() && (!bl2.booleanValue() || n != 0)) {
            this.getEUtranCellRelations(arrayList, arrayList2, coordinator);
            this.validateCellRelations(arrayList, coordinator);
            this.validateCellRelations(arrayList2, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "validateAtPrepare()");
    }

    private void validateCellRelations(List list, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateCellRelations()");
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Boolean bl;
            ManagedObject managedObject = (ManagedObject)iterator.next();
            if (MoCheck.isMoNotReadable(managedObject) || !(bl = (Boolean)managedObject.getAttribute("includeInSystemInformation", coordinator)).booleanValue()) continue;
            Boolean bl2 = (Boolean)managedObject.getAttribute("isHoAllowed", coordinator);
            Integer n2 = (Integer)managedObject.getAttribute("qOffsetCellEUtran", coordinator);
            if (n2 == 0 || bl2 != Boolean.TRUE) continue;
            ++n;
        }
        logger.traceDebug(THIS_CLASS, "NeighCellList is: " + n);
        logger.traceReturn(THIS_CLASS, "validateCellRelations()");
    }

    private void getEUtranCellRelations(List list, List list2, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getEUtranCellRelations()");
        Integer n = (Integer)this.eUtranCellXdd.getAttribute(this.eUtranCellEarfcnAttributeName, coordinator);
        List list3 = GetChildrenByTypeHelper.getInstance().getAllGrandChildrenByTypeFromMo(this.eUtranCellXdd, "EUtranFreqRelation", "EUtranCellRelation");
        String string = this.getSourceFreqRelLdn(n, coordinator);
        Iterator iterator = list3.iterator();
        while (iterator != null && iterator.hasNext()) {
            ManagedObject managedObject = (ManagedObject)iterator.next();
            this.addToCorrectList(managedObject, list, list2, string);
        }
        logger.traceReturn(THIS_CLASS, "getEUtranCellRelations()");
    }

    private String getSourceFreqRelLdn(Integer n, Coordinator coordinator) throws MoAccessException {
        String string = null;
        List list = GetChildrenByTypeHelper.getInstance().getAllChildrenByTypeFromMo(this.eUtranCellXdd, "EUtranFreqRelation");
        Iterator iterator = list.iterator();
        while (iterator != null && iterator.hasNext()) {
            ManagedObject managedObject;
            Integer n2;
            ManagedObject managedObject2 = (ManagedObject)iterator.next();
            if (MoCheck.isMoNotReadable(managedObject2) || !n.equals(n2 = (Integer)(managedObject = (ManagedObject)managedObject2.getAttribute("eutranFrequencyRef", coordinator)).getAttribute("arfcnValueEUtranDl", coordinator))) continue;
            string = managedObject2.getLocalDistinguishedName();
            break;
        }
        return string;
    }

    private void addToCorrectList(ManagedObject managedObject, List list, List list2, String string) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "addToCorrectList()");
        ManagedObject managedObject2 = managedObject.getParent();
        if (managedObject2.getLocalDistinguishedName().equals(string)) {
            list.add(managedObject);
        } else {
            list2.add(managedObject);
        }
        logger.traceReturn(THIS_CLASS, "addToCorrectList()");
    }
}

