/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.mao.utranfreqrelation.UtranFreqRelationMaoImpl;

public class LimitUtranCellRelationsValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = LimitUtranCellRelationsValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String VALIDATION_FAIL_MESSAGE = "Maximum number of UtranCellRelations per UtranFreqRelation has been reached";

    public LimitUtranCellRelationsValidator(String string) {
        super(THIS_CLASS.getName(), string, true, false, false);
        logger.traceEnter(THIS_CLASS, THIS_CLASS.getName() + "(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, THIS_CLASS.getName() + "()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject2 = managedObject.getParent();
        if (!managedObject2.getClass().equals(UtranFreqRelationMaoImpl.class)) {
            return;
        }
        Integer n = (Integer)managedObject2.getAttribute("maxNrUtranCellRelations", coordinator);
        MoIterator moIterator = managedObject2.getChildren();
        if (moIterator.size() - 1 == n) {
            this.logAndThrowPrepareFailedException(VALIDATION_FAIL_MESSAGE);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }
}

