/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.common.validator.AilgAndMbmsActivationCheckWrapper;
import se.ericsson.lte.rbs.omf.common.validator.MbmsOverlapAlgorithm;

public class MbsfnAreaCellRelationMoTypeValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = MbsfnAreaCellRelationMoTypeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private Coordinator coordinator;

    public MbsfnAreaCellRelationMoTypeValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, "MbsfnAreaCellRelationMoTypeValidator(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, "MbsfnAreaCellRelationMoTypeValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        Object object;
        this.coordinator = coordinator;
        this.verifyAildAndMbmsActivation(managedObject);
        ManagedObject managedObject2 = managedObject.getParent();
        this.checkIfFirstCellRelation(managedObject2.getChildren());
        List list = this.getAllCells(managedObject2.getChildren());
        ManagedObject managedObject3 = this.getCell(managedObject);
        list.remove(managedObject3);
        this.verifyUniqueCell(managedObject3, list);
        if (!list.isEmpty()) {
            object = (ManagedObject)list.get(0);
            this.verifySameCellType(managedObject3, (ManagedObject)object);
            this.verifySameBandwidthAndFreq(managedObject3, (ManagedObject)object);
        }
        if (this.isAdministrativeStateStillEnabled(managedObject2)) {
            object = new MbmsOverlapAlgorithm();
            ((MbmsOverlapAlgorithm)object).runOverlapAlgorithm(managedObject2, this.coordinator);
        }
    }

    private void verifyAildAndMbmsActivation(ManagedObject managedObject) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        StringBuffer stringBuffer = new StringBuffer();
        if (AilgAndMbmsActivationCheckWrapper.getInstance().checkIfMbmsAndAilgAreBothActivated(managedObject, this.coordinator, stringBuffer)) {
            this.logAndThrowPrepareFailedException(stringBuffer.toString());
        }
    }

    private boolean isAdministrativeStateStillEnabled(ManagedObject managedObject) throws MoAccessException, NoSuchAttributeException {
        return (Integer)managedObject.getAttribute("administrativeState", null) == 1 && (Integer)managedObject.getAttribute("administrativeState", this.coordinator) == 1;
    }

    private void checkIfFirstCellRelation(MoIterator moIterator) throws MoAccessException, NoSuchAttributeException, PrepareFailedException {
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (moIterator.hasMoreElements() && n < 2) {
            ManagedObject managedObject = moIterator.nextMo();
            if (managedObject.getType().equals("MbsfnAreaCellRelation")) {
                ++n;
                continue;
            }
            MoIterator moIterator2 = managedObject.getChildren();
            while (moIterator2.hasMoreElements()) {
                arrayList.add(moIterator2.nextElement());
            }
        }
        if (n == 1) {
            this.verifyThatNoServiceIsEnabled(arrayList);
        }
    }

    private void verifyThatNoServiceIsEnabled(List list) throws MoAccessException, NoSuchAttributeException, PrepareFailedException {
        for (int i = 0; i < list.size(); ++i) {
            int n = (Integer)((ManagedObject)list.get(i)).getAttribute("operationalState", this.coordinator);
            if (n != 1) continue;
            this.logAndThrowPrepareFailedException("Not allowed to add first MbsfnAreaCellRelation to an MbsfnArea having a MbsmService with operationalState ENABLED.");
        }
    }

    private List getAllCells(MoIterator moIterator) throws NoSuchAttributeException, MoAccessException {
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!MoCheck.isMoReadable(managedObject) || !managedObject.getType().equals("MbsfnAreaCellRelation")) continue;
            arrayList.add(this.getCell(managedObject));
        }
        return arrayList;
    }

    private ManagedObject getCell(ManagedObject managedObject) throws NoSuchAttributeException, MoAccessException {
        return (ManagedObject)managedObject.getAttribute("mbsfnAreaCellRef", this.coordinator);
    }

    private void verifyUniqueCell(ManagedObject managedObject, List list) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!managedObject.equals(iterator.next())) continue;
            this.logAndThrowPrepareFailedException("The mbsfnAreaCellRef points to a cell already used by another MbsfnAreaCellRelation.");
        }
    }

    private void verifySameCellType(ManagedObject managedObject, ManagedObject managedObject2) throws PrepareFailedException {
        if (this.isFDDCell(managedObject) != this.isFDDCell(managedObject2)) {
            this.logAndThrowPrepareFailedException("The MbsfnAreaCellRelation points to a " + managedObject.getType() + ", but the area already has cells of type " + managedObject2.getType() + ".");
        }
    }

    private boolean isFDDCell(ManagedObject managedObject) {
        return managedObject.getType().equals("EUtranCellFDD");
    }

    private void verifySameBandwidthAndFreq(ManagedObject managedObject, ManagedObject managedObject2) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        BandwidthAndFreqVerifier bandwidthAndFreqVerifier = this.getNewBandwidthFreqVerifier(managedObject);
        bandwidthAndFreqVerifier.verifyBandwidthAndFreq(managedObject, managedObject2);
    }

    private BandwidthAndFreqVerifier getNewBandwidthFreqVerifier(ManagedObject managedObject) {
        BandwidthAndFreqVerifier bandwidthAndFreqVerifier = this.isFDDCell(managedObject) ? new BandwidthAndFreqVerifierFDD() : new BandwidthAndFreqVerifierTDD();
        return bandwidthAndFreqVerifier;
    }

    private class BandwidthAndFreqVerifierTDD
    extends BandwidthAndFreqVerifier {
        public BandwidthAndFreqVerifierTDD() {
            super("earfcn", "channelBandwidth");
        }
    }

    private class BandwidthAndFreqVerifierFDD
    extends BandwidthAndFreqVerifier {
        public BandwidthAndFreqVerifierFDD() {
            super("earfcndl", "dlChannelBandwidth");
        }
    }

    private class BandwidthAndFreqVerifier {
        private final String frequencyId;
        private final String bandwidthId;

        public BandwidthAndFreqVerifier(String string, String string2) {
            this.frequencyId = string;
            this.bandwidthId = string2;
        }

        public void verifyBandwidthAndFreq(ManagedObject managedObject, ManagedObject managedObject2) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
            this.verifyBandwidth(managedObject, managedObject2);
            this.verifyFrequency(managedObject, managedObject2);
        }

        private void verifyBandwidth(ManagedObject managedObject, ManagedObject managedObject2) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
            int n;
            int n2 = (Integer)managedObject.getAttribute(this.bandwidthId, MbsfnAreaCellRelationMoTypeValidator.this.coordinator);
            if (n2 != (n = ((Integer)managedObject2.getAttribute(this.bandwidthId, MbsfnAreaCellRelationMoTypeValidator.this.coordinator)).intValue())) {
                MbsfnAreaCellRelationMoTypeValidator.this.logAndThrowPrepareFailedException("The MbsfnAreaCellRelation points to a cell with a " + this.bandwidthId + " which is not the same as another cell already used by the MbsfnArea. CellId of the configured relations is " + this.getCellId(managedObject2) + ".");
            }
        }

        private void verifyFrequency(ManagedObject managedObject, ManagedObject managedObject2) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
            int n;
            int n2 = (Integer)managedObject.getAttribute(this.frequencyId, MbsfnAreaCellRelationMoTypeValidator.this.coordinator);
            if (n2 != (n = ((Integer)managedObject2.getAttribute(this.frequencyId, MbsfnAreaCellRelationMoTypeValidator.this.coordinator)).intValue())) {
                MbsfnAreaCellRelationMoTypeValidator.this.logAndThrowPrepareFailedException("The MbsfnAreaCellRelation points to a cell with an " + this.frequencyId + " which is not the same as another cell already used by the MbsfnArea. CellId of the configured relations is " + this.getCellId(managedObject2) + ".");
            }
        }

        private Integer getCellId(ManagedObject managedObject) throws NoSuchAttributeException, MoAccessException {
            return (Integer)managedObject.getAttribute("cellId", MbsfnAreaCellRelationMoTypeValidator.this.coordinator);
        }
    }
}

