/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.TmgiContainer;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.mao.mbsfnarea.MbsfnAreaMaoImpl;

public class McchModificationPeriodValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = McchModificationPeriodValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext genericMaoContext;

    public McchModificationPeriodValidator(String string, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, "McchModificationPeriodValidator(attribute " + string + ")");
        this.genericMaoContext = genericMaoContext;
        logger.traceReturn(THIS_CLASS, "McchModificationPeriodValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        this.checkMcchModificationPeriod(managedObject, coordinator);
    }

    private void checkMcchModificationPeriod(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        Integer n = (Integer)managedObject.getAttribute("mcchModificationPeriod", coordinator);
        TmgiContainer tmgiContainer = new TmgiContainer();
        tmgiContainer.addTmgis((MbsfnAreaMaoImpl)managedObject, coordinator);
        TmgiContainer tmgiContainer2 = new TmgiContainer();
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("MbsfnArea");
        while (moIterator != null && moIterator.hasMoreElements()) {
            tmgiContainer2.clear();
            MbsfnAreaMaoImpl mbsfnAreaMaoImpl = (MbsfnAreaMaoImpl)moIterator.nextMo();
            Integer n2 = (Integer)mbsfnAreaMaoImpl.getAttribute("mcchModificationPeriod", coordinator);
            if (n.equals(n2)) continue;
            tmgiContainer2.addTmgis(tmgiContainer);
            tmgiContainer2.addTmgis(mbsfnAreaMaoImpl, coordinator);
            if (!tmgiContainer2.containsSameTmgiTwice()) continue;
            this.logAndThrowPrepareFailedException("Area " + managedObject.getFullDistinguishedName() + " and area " + mbsfnAreaMaoImpl.getFullDistinguishedName() + " have different mcchModificationPeriod but have child services with same TMGI(s). This is not allowed.");
        }
    }
}

