/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class MchSchedulingPeriodValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = MchSchedulingPeriodValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public MchSchedulingPeriodValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, "MchSchedulingPeriodValidator(attribute " + string + ")");
        logger.traceReturn(THIS_CLASS, "MchSchedulingPeriodValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        if (!this.areAllSyncSequenceLengthCorrectComparedToMchSchedulingPeriod(managedObject, coordinator)) {
            this.logAndThrowPrepareFailedException("An MbmsService has a syncSequenceLength that is smaller than the mchSchedulingPeriod in the PmchMch.");
        }
    }

    private boolean areAllSyncSequenceLengthCorrectComparedToMchSchedulingPeriod(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        boolean bl = true;
        MoIterator moIterator = managedObject.getChildren();
        if (moIterator.size() > 0) {
            int n = (Integer)managedObject.getAttribute("mchSchedulingPeriod", coordinator);
            while (moIterator.hasMoreElements() && bl) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (!MoCheck.isMoReadable(managedObject2) || !managedObject2.getType().equals("MbmsService")) continue;
                int n2 = (Integer)managedObject2.getAttribute("syncSequenceLength", coordinator);
                bl = this.checkIfValid(n, n2);
            }
        }
        return bl;
    }

    private boolean checkIfValid(int n, int n2) {
        boolean bl = true;
        if (n < n2) {
            bl = false;
        }
        return bl;
    }
}

