/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class PmEventServiceValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = PmEventServiceValidator.class;
    private static final String UE_TRACE_FILE_SIZE = "ueTraceFileSize";
    private static final String TOTAL_UE_TRACE_STORAGE_SIZE = "totalUeTraceStorageSize";
    private static final String TOTAL_EVENT_STORAGE_SIZE = "totalEventStorageSize";
    private static final String TOTAL_CELL_TRACE_STORAGE_SIZE = "totalCellTraceStorageSize";
    private static final String CELL_TRACE_FILE_SIZE = "cellTraceFileSize";

    public PmEventServiceValidator() {
        super(THIS_CLASS.getName(), THIS_CLASS.getName(), true, true, false);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        Integer n = (Integer)managedObject.getAttribute(UE_TRACE_FILE_SIZE, coordinator);
        Integer n2 = (Integer)managedObject.getAttribute(TOTAL_UE_TRACE_STORAGE_SIZE, coordinator);
        Integer n3 = (Integer)managedObject.getAttribute(TOTAL_EVENT_STORAGE_SIZE, coordinator);
        Integer n4 = (Integer)managedObject.getAttribute(TOTAL_CELL_TRACE_STORAGE_SIZE, coordinator);
        Integer n5 = (Integer)managedObject.getAttribute(CELL_TRACE_FILE_SIZE, coordinator);
        this.validateUeTraceFileSize(n, n2);
        this.validateCellTraceFileSize(n5, n4);
        this.validateTotalUeTraceStorageSize(n2, n3);
        this.validateTotalCellTraceStorageSize(n4, n3);
        this.validateTotalEventStorageSize(n3, n4, n2);
    }

    protected final void validateUeTraceFileSize(int n, int n2) throws PrepareFailedException {
        if (n > n2) {
            this.logAndThrowPrepareFailedException("Illegal parameter value: ueTraceFileSize(" + n + ") <= totalUeTraceStorageSize(" + n2 + ")");
        }
    }

    protected final void validateCellTraceFileSize(int n, int n2) throws PrepareFailedException {
        if (n > n2) {
            this.logAndThrowPrepareFailedException("Illegal parameter value: cellTraceFileSize(" + n + ") <= totalCellTraceStorageSize(" + n2 + ")");
        }
    }

    protected final void validateTotalUeTraceStorageSize(int n, int n2) throws PrepareFailedException {
        if (n > n2) {
            this.logAndThrowPrepareFailedException("Illegal parameter value: totalUeTraceStorageSize(" + n + ") <= totalEventStorageSize(" + n2 + ")");
        }
    }

    protected final void validateTotalCellTraceStorageSize(int n, int n2) throws PrepareFailedException {
        if (n > n2) {
            this.logAndThrowPrepareFailedException("Illegal Parameter Value: totalCellTraceStorageSize");
        }
    }

    protected final void validateTotalEventStorageSize(int n, int n2, int n3) throws PrepareFailedException {
        if (n < n2 + n3) {
            this.logAndThrowPrepareFailedException("Illegal parameter value:  totalEventStorageSize(" + n + ") >= totalCellTraceStorageSize(" + n2 + ") + totalUeTraceStorageSize(" + n3 + ")");
        }
    }
}

