/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class PwsSiWindowLengthValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = PwsSiWindowLengthValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext genericMaoContext;
    private static final String VALIDATE_FAIL_MESSAGE = "Possible some UEs do not receive broadcast Public Warning Messages because SI window is too small.";
    private static final String MO_TYPE_OPTIONAL_FEATURE_LICENSE = "OptionalFeatureLicense";
    private static final String ATTR_NAME_KEY_ID = "keyId";
    private static final String ATTR_NAME_LICENSE_STATE = "licenseState";
    private static final String ATTR_NAME_FEATURE_STATE = "featureState";
    private static final String ATTR_NAME_ADMINISTRATIVE_STATE = "administrativeState";
    private static final String ATTR_VALUE_PWS_LICENSE_KEY_ID = "CXC4011252";
    private static final int MIN_SI_WINDOW_LENGTH_PWS_ACTIVATED = 10;
    private static final int PWS_LICENSE_ENABLED = 1;
    private static final int PWS_FEATURE_ACTIVATED = 1;

    public PwsSiWindowLengthValidator(String string, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.genericMaoContext = genericMaoContext;
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate()");
        if (!this.isAdministrativeStateChanged(managedObject, coordinator)) {
            int n = (Integer)managedObject.getAttribute(this.attributeName, coordinator);
            if (this.isPwsFeatureEnabled(coordinator) && n < 10) {
                this.logAndThrowPrepareFailedException(VALIDATE_FAIL_MESSAGE);
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private boolean isAdministrativeStateChanged(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        int n;
        int n2 = (Integer)managedObject.getAttribute(ATTR_NAME_ADMINISTRATIVE_STATE, null);
        return n2 != (n = ((Integer)managedObject.getAttribute(ATTR_NAME_ADMINISTRATIVE_STATE, coordinator)).intValue());
    }

    private boolean isPwsFeatureEnabled(Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(MO_TYPE_OPTIONAL_FEATURE_LICENSE);
        while (moIterator != null && moIterator.hasMoreElements()) {
            String string;
            ManagedObject managedObject = (ManagedObject)moIterator.nextElement();
            if (!MoCheck.isMoReadable(managedObject) || !ATTR_VALUE_PWS_LICENSE_KEY_ID.equals(string = (String)managedObject.getAttribute(ATTR_NAME_KEY_ID, coordinator))) continue;
            int n = (Integer)managedObject.getAttribute(ATTR_NAME_LICENSE_STATE, coordinator);
            int n2 = (Integer)managedObject.getAttribute(ATTR_NAME_FEATURE_STATE, coordinator);
            bl = n == 1 && n2 == 1;
        }
        return bl;
    }
}

