/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class RangeCombinationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = RangeCombinationValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String fixedAttributeName;
    private final Object[] fixedAttributeValues;
    private final String rangeAttributeName;
    private final int[] lowerRangeLimits;
    private final int[] upperRangeLimits;

    public RangeCombinationValidator(String string, int n, String string2, int n2, int n3) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.fixedAttributeName = string;
        this.fixedAttributeValues = new Object[]{new Integer(n)};
        this.rangeAttributeName = string2;
        this.lowerRangeLimits = new int[]{n2};
        this.upperRangeLimits = new int[]{n3};
    }

    public RangeCombinationValidator(String string, int[] nArray, String string2, int[] nArray2, int[] nArray3) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.fixedAttributeName = string;
        this.fixedAttributeValues = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.fixedAttributeValues[i] = new Integer(nArray[i]);
        }
        this.rangeAttributeName = string2;
        this.lowerRangeLimits = nArray2;
        this.upperRangeLimits = nArray3;
    }

    public RangeCombinationValidator(String string, Object object, String string2, int n, int n2) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.fixedAttributeName = string;
        this.fixedAttributeValues = new Object[]{object};
        this.rangeAttributeName = string2;
        this.lowerRangeLimits = new int[]{n};
        this.upperRangeLimits = new int[]{n2};
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        Object object = managedObject.getAttribute(this.fixedAttributeName, coordinator);
        Integer n = (Integer)managedObject.getAttribute(this.rangeAttributeName, coordinator);
        for (int i = 0; i < this.fixedAttributeValues.length; ++i) {
            if (!this.fixedAttributeValues[i].equals(object) || n >= this.lowerRangeLimits[i] && n <= this.upperRangeLimits[i]) continue;
            String string = "The combination of attributes " + this.fixedAttributeName + " with value [" + object + "] and " + this.rangeAttributeName + " with value [" + n + "] is not valid";
            this.logAndThrowPrepareFailedException(string);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }
}

