/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class RefParentIsReservedByValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = RefParentIsReservedByValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String wantedReservedByMoType;
    private final String reservedByAttribute;
    private final GenericMaoContext genericMaoContext;

    public RefParentIsReservedByValidator(String string, String string2, String string3, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.wantedReservedByMoType = string2;
        this.reservedByAttribute = string3;
        this.genericMaoContext = genericMaoContext;
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject2 = this.getReferensedMo(managedObject, coordinator);
        this.validateReservedBy(managedObject, managedObject2.getParent(), coordinator);
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private ManagedObject getReferensedMo(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getReferensedMo()");
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(this.attributeName, coordinator);
        if (managedObject2 == null) {
            this.logAndThrowPrepareFailedException("The MO [" + managedObject.getLocalDistinguishedName() + "] does not have any referense set to attribute " + this.attributeName);
        }
        logger.traceReturn(THIS_CLASS, "getReferensedMo()");
        return managedObject2;
    }

    private void validateReservedBy(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        Object object;
        logger.traceEnter(THIS_CLASS, "validateReservedBy()");
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(this.wantedReservedByMoType);
        boolean bl = false;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject3;
            object = moIterator.nextMo();
            if (MoCheck.isMoNotReadable(object) || (managedObject3 = (ManagedObject)object.getAttribute(this.reservedByAttribute, coordinator)) == null || !managedObject3.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            object = "The MO [" + managedObject.getLocalDistinguishedName() + "] can not be created. There must exist a " + this.wantedReservedByMoType + " with a reference to the MO [" + managedObject2.getLocalDistinguishedName() + "]";
            this.logAndThrowPrepareFailedException((String)object);
        }
        logger.traceReturn(THIS_CLASS, "validateReservedBy()");
    }
}

