/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ReservedByMaxNrOfMOsValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ReservedByMaxNrOfMOsValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String VALIDATION_FAIL_MESSAGE_1 = "Maximum number of MOs of type ";
    protected static final String VALIDATION_FAIL_MESSAGE_2 = " in reservedBy attribute on ";
    protected static final String VALIDATION_FAIL_MESSAGE_3 = " already reached. Maximum possible number is ";
    private static final String RESERVED_BY = "reservedBy";
    private final int localMaxNr;
    private final String localMoType;
    private final String localAttribute;

    public ReservedByMaxNrOfMOsValidator(String string, String string2, int n) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, THIS_CLASS.getName() + "(attribute " + string + ")");
        this.localMaxNr = n;
        this.localMoType = string2;
        this.localAttribute = string;
        logger.traceReturn(THIS_CLASS, THIS_CLASS.getName() + "()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject[] managedObjectArray = null;
        Object object = managedObject.getAttribute(this.localAttribute, coordinator);
        managedObjectArray = object instanceof ManagedObject ? new ManagedObject[]{(ManagedObject)object} : (ManagedObject[])object;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObjectArray[i].getAttribute(RESERVED_BY, coordinator);
            int n = 0;
            for (int j = 0; j < managedObjectArray2.length; ++j) {
                if (!this.localMoType.equals(managedObjectArray2[j].getType())) continue;
                ++n;
            }
            if (n <= this.localMaxNr) continue;
            String string = VALIDATION_FAIL_MESSAGE_1 + this.localMoType + VALIDATION_FAIL_MESSAGE_2 + managedObjectArray[i].getLocalDistinguishedName() + VALIDATION_FAIL_MESSAGE_3 + this.localMaxNr;
            this.logAndThrowPrepareFailedException(string);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }
}

