/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ResourcePartitionGroupMemberValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ResourcePartitionGroupMemberValidator.class;
    private static final String PLMNLIST = "plmnList";
    private static final String PARTITIONNAME = "partitionName";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public ResourcePartitionGroupMemberValidator(String string) {
        super(THIS_CLASS.getName(), string, true, true, false);
        logger.traceReturn(THIS_CLASS, "ResourcePartitionGroupMember()");
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(this.attributeName, coordinator);
        if (null == managedObject2 || this.isInvalidPartition(managedObject2, coordinator)) {
            this.logAndThrowPrepareFailedException("Partition Group Members can only reference a valid Resource Partition, i.e. plmnList configured and partitionName a value [1..24]");
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    public boolean isInvalidPartition(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        boolean bl = false;
        Object[] objectArray = (Object[])managedObject.getAttribute(PLMNLIST, coordinator);
        String string = (String)managedObject.getAttribute(PARTITIONNAME, coordinator);
        if (objectArray.length == 0) {
            bl = true;
        }
        if (string.length() == 0) {
            bl = true;
        }
        return bl;
    }
}

