/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ResourcePartitionValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ResourcePartitionValidator.class;
    private static final String SPIDLIST = "spidList";
    private static final String RESERVEDBY = "reservedBy";
    private static final String PARTITIONNAME = "partitionName";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public ResourcePartitionValidator(String string) {
        super(THIS_CLASS.getName(), string, true, true, false);
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        ManagedObject[] managedObjectArray;
        logger.traceEnter(THIS_CLASS, "validate()");
        String string = (String)managedObject.getAttribute(PARTITIONNAME, coordinator);
        logger.traceEnter(THIS_CLASS, string);
        Object[] objectArray = (Object[])managedObject.getAttribute(SPIDLIST, coordinator);
        if (objectArray.length != 0) {
            this.logAndThrowPrepareFailedException("The attribute spidList is not supported.");
        }
        if ((managedObjectArray = (ManagedObject[])managedObject.getAttribute(RESERVEDBY, coordinator)).length != 0) {
            this.logAndThrowPrepareFailedException("It is not allowed to modify ResourcePartition MO, when referenced by other MO.");
        }
        if (!this.validatePartitionId(managedObject, coordinator)) {
            this.logAndThrowPrepareFailedException("The attribute partitionName must be unique and in range [1..24].");
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private boolean validatePartitionId(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        boolean bl = true;
        String string = (String)managedObject.getAttribute(PARTITIONNAME, coordinator);
        if (string.length() != 0) {
            if (!this.isIdUnique(managedObject, coordinator)) {
                bl = false;
            }
            try {
                Integer.parseInt(string);
                if (Integer.parseInt(string) < 1 || Integer.parseInt(string) > 24) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isIdUnique(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        boolean bl = true;
        String string = (String)managedObject.getAttribute(PARTITIONNAME, coordinator);
        MoIterator moIterator = managedObject.getParent().getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            String string2 = (String)managedObject2.getAttribute(PARTITIONNAME, coordinator);
            if (managedObject.getId().equals(managedObject2.getId()) || !string.equals(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

