/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.mao.qciprofilepredefined.QciProfilePredefinedMaoImpl;

public class RlcModeValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = RlcModeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public RlcModeValidator() {
        super(THIS_CLASS.getName(), "rlcMode", false, true, false);
        logger.traceEnter(THIS_CLASS, "RlcModeValidator()");
        logger.traceReturn(THIS_CLASS, "RlcModeValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        Integer n = (Integer)managedObject.getAttribute("rlcMode", coordinator);
        Integer n2 = (Integer)managedObject.getAttribute("rlcSNLength", coordinator);
        Integer n3 = (Integer)managedObject.getAttribute("pdcpSNLength", coordinator);
        Integer n4 = QciProfilePredefinedMaoImpl.RLC_MODE_TM;
        if (n.equals(n4)) {
            this.logAndThrowPrepareFailedException("The value 'TM' of rlcMode attribute is not supported.");
        } else if (!(!QciProfilePredefinedMaoImpl.RLC_MODE_AM.equals(n) || QciProfilePredefinedMaoImpl.RLC_S_N_LENGTH_DEFAULT.equals(n2) && QciProfilePredefinedMaoImpl.PDCP_S_N_LENGTH_DEFAULT.equals(n3))) {
            this.logAndThrowPrepareFailedException("When rlcMode is set to AM, rlcSNLength and pdcpSNLength must be set to their default values.");
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }
}

