/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class SameFreqRefInExternalCellRelationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = SameFreqRefInExternalCellRelationValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public SameFreqRefInExternalCellRelationValidator(String string) {
        super(THIS_CLASS.getName(), string, true, true, false);
        logger.traceEnter(THIS_CLASS, "SameFreqRefInExternalCellRelationValidator(attribute " + string + ")");
        this.attributeName = string;
        logger.traceReturn(THIS_CLASS, "SameFreqRefInExternalCellRelationValidator()");
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(this.attributeName, coordinator);
        this.checkEarfcnRange(managedObject, managedObject2, coordinator);
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute("reservedBy", coordinator);
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                ManagedObject managedObject3;
                ManagedObject managedObject4;
                ManagedObject managedObject5 = managedObjectArray[i];
                if (MoCheck.isMoNotReadable(managedObject5) || managedObject2.equals(managedObject4 = (ManagedObject)(managedObject3 = managedObject5.getParent()).getAttribute(this.attributeName, coordinator))) continue;
                this.logAndThrowPrepareFailedException(this.attributeName + " doesn't refer to the same EUtranFrequency as the neighbor cells EUtranFreqRelation");
            }
        }
    }

    private void checkEarfcnRange(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        Integer n = (Integer)managedObject2.getAttribute("arfcnValueEUtranDl", coordinator);
        if (managedObject.getType().equals("ExternalEUtranCellFDD") && !this.isFddEarfcnValid(n)) {
            String string = "It is only possible to configure a reference to a EUtranFrequency with a FDD ARFCN. The reference [" + managedObject2.getLocalDistinguishedName() + "] with earfcn [" + n + "] is not valid.";
            this.logAndThrowPrepareFailedException(string);
        } else if (managedObject.getType().equals("ExternalEUtranCellTDD") && n < 36000) {
            String string = "It is only possible to configure a reference to a EUtranFrequency with a TDD ARFCN. The reference [" + managedObject2.getLocalDistinguishedName() + "] with earfcn [" + n + "] is not valid.";
            this.logAndThrowPrepareFailedException(string);
        }
    }

    private boolean isFddEarfcnValid(Integer n) {
        return n < 18000 || n > 46589 && n < 262144;
    }
}

