/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.AttributeUtilities;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class SameMoTypeValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = SameMoTypeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final boolean shouldBeUnique;
    protected final GenericMaoContext genericMaoContext;

    public SameMoTypeValidator(String string, boolean bl, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        logger.traceEnter(THIS_CLASS, "SameMoTypeValidator(attribute " + string + ")");
        this.genericMaoContext = genericMaoContext;
        this.shouldBeUnique = bl;
        logger.traceReturn(THIS_CLASS, "SameMoTypeValidator()");
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(mo[" + managedObject.getLocalDistinguishedName() + "], myAttributeName[" + this.attributeName + "], shouldBeUnique[" + this.shouldBeUnique + "])");
        MoIterator moIterator = this.getMoIterator(managedObject);
        Object[] objectArray = new Object[]{managedObject.getAttribute(this.attributeName, coordinator)};
        if (this.shouldBeUnique) {
            AttributeUtilities.validateAttributeShouldBeUnique(moIterator, managedObject, objectArray, this.attributeName, coordinator);
        } else {
            AttributeUtilities.validateAttributeShouldBeSame(moIterator, managedObject, objectArray, this.attributeName, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    protected MoIterator getMoIterator(ManagedObject managedObject) {
        logger.traceEnter(THIS_CLASS, "getMoIterator(" + managedObject + ")");
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(managedObject.getType());
        return moIterator;
    }
}

